package com.zoyi.channel.plugin.android.model.etc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.enumerate.ExposureType;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.store2.InAppPushStore;
import com.zoyi.channel.plugin.android.util.ParseUtils;

/**
 * Created by jerry on 2018. 11. 14..
 */

public class ChatPushItem implements PushItem, Entity {

  private long createdAt;
  @NonNull
  private ProfileEntity profile;
  @Nullable
  private String title;
  @NonNull
  private String chatId;
  private SpannableStringBuilder formattedSpanMessage;

  public ChatPushItem(
      long createdAt,
      @NonNull ProfileEntity profile,
      @Nullable String title,
      @NonNull String message,
      @NonNull String chatId
  ) {
    this.createdAt = createdAt;
    this.profile = profile;
    this.title = title;
    this.formattedSpanMessage = ParseUtils.parseMessage(message);
    this.chatId = chatId;
  }

  @Override
  public long getCreatedAt() {
    return createdAt;
  }

  @NonNull
  @Override
  public ProfileEntity getProfile() {
    return profile;
  }

  @Nullable
  @Override
  public String getTitle() {
    return title;
  }

  @Override
  public SpannableStringBuilder getFormattedSpanMessage() {
    return formattedSpanMessage;
  }

  @Override
  public SpannableStringBuilder getFormattedSpanMessageWithTitle() {
    return getFormattedSpanMessage();
  }

  @Override
  public ExposureType getMobileExposureType() {
    return ExposureType.IN_APP_PUSH;
  }

  @Override
  public String getContentUrl() {
    return null;
  }

  @Override
  public String getAttachment() {
    return null;
  }

  @Override
  public String getButtonTitle() {
    return null;
  }

  @Override
  public PreviewThumb getImageThumb() {
    return null;
  }

  @NonNull
  public String getChatId() {
    return chatId;
  }

  @Override
  public String getId() {
    return chatId;
  }
}
