/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.PushItem;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.push_bot.OnPushClickListener;
import com.zoyi.channel.plugin.android.store2.InAppPushStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.AlarmCenter;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public abstract class BasePushView
extends LinearLayout {
    protected Context context;
    protected View root;
    protected View itemRoot;
    @Nullable
    protected View buttonPopupClose;
    @Nullable
    protected AvatarLayout avatarPopup;
    @Nullable
    protected TextView textPopupName;
    @Nullable
    protected TextView textPopupTime;
    @Nullable
    protected TextView textPopupMessage;
    protected ViewGroup layoutPushBotPopupImage;
    protected ImageView imagePushBotPopupImage;
    protected View buttonPushBotPopupButton;
    @Nullable
    protected OnPushClickListener onPushClickListener;
    @Nullable
    protected Binder binder;
    @Nullable
    protected PushItem item;

    public BasePushView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public BasePushView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BasePushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    protected abstract int getLayoutId();

    @Initializer
    protected void init(Context context) {
        this.context = context;
        this.root = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.root.setVisibility(8);
        this.itemRoot = this.root.findViewById(R.id.ch_root_popup);
        this.buttonPopupClose = this.root.findViewById(R.id.ch_button_popup_close);
        this.avatarPopup = (AvatarLayout)this.root.findViewById(R.id.ch_avatar_popup);
        this.textPopupName = (TextView)this.root.findViewById(R.id.ch_text_popup_name);
        this.textPopupTime = (TextView)this.root.findViewById(R.id.ch_text_popup_time);
        this.textPopupMessage = (TextView)this.root.findViewById(R.id.ch_text_popup_message);
        this.layoutPushBotPopupImage = (ViewGroup)this.root.findViewById(R.id.ch_layout_popup_image);
        this.imagePushBotPopupImage = (ImageView)this.root.findViewById(R.id.ch_image_popup_image);
        this.buttonPushBotPopupButton = this.root.findViewById(R.id.ch_layout_popup_button);
        if (this.buttonPopupClose != null) {
            this.buttonPopupClose.setOnClickListener(v -> this.hide());
        }
        this.itemRoot.setOnClickListener(v -> {
            if (this.item != null && this.onPushClickListener != null) {
                this.onPushClickListener.onPushClick(this.item.getMobileExposureType(), this.item.getId());
            }
            this.hide();
        });
        this.layoutPushBotPopupImage.setOnClickListener(v -> {
            if (this.item != null && this.onPushClickListener != null) {
                this.onPushClickListener.onPushContentsClick(this.item.getId(), this.item.getContentUrl());
            }
            this.hide();
        });
        this.buttonPushBotPopupButton.setOnClickListener(v -> {
            if (this.item != null && this.onPushClickListener != null) {
                this.onPushClickListener.onPushContentsClick(this.item.getId(), this.item.getContentUrl());
            }
            this.hide();
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
        }
    }

    protected void bindProfileData(PushItem pushItem) {
        ProfileEntity person = pushItem.getProfile();
        if (this.avatarPopup != null) {
            this.avatarPopup.set(person);
        }
        if (this.textPopupName != null) {
            this.textPopupName.setText((CharSequence)(person != null ? person.getName() : ResUtils.getUnknown()));
        }
        if (this.textPopupTime != null) {
            this.textPopupTime.setText((CharSequence)TimeUtils.getTime(pushItem.getCreatedAt()));
        }
    }

    public void setPushBotClickListener(OnPushClickListener onPushClickListener) {
        this.onPushClickListener = onPushClickListener;
    }

    public void show(PushItem pushItem) {
        this.resetView();
        this.item = pushItem;
        this.bindProfileData(pushItem);
        this.bindContent(pushItem);
        this.bindTitle(pushItem);
        if (PrefSupervisor.isEnabledPushAlarm(this.context)) {
            AlarmCenter.alarm(this.context);
        }
        if (pushItem.getAttachment() != null) {
            switch (pushItem.getAttachment()) {
                case "button": {
                    this.bindButton();
                    break;
                }
                case "image": {
                    this.bindImage();
                }
            }
        }
        this.root.setVisibility(0);
    }

    private void hide() {
        this.resetView();
        InAppPushStore.get().pushItem.reset();
    }

    public void resetView() {
        this.item = null;
        this.root.setVisibility(8);
        this.buttonPushBotPopupButton.setVisibility(8);
        Glide.clear((View)this.imagePushBotPopupImage);
        this.layoutPushBotPopupImage.setVisibility(8);
        if (this.textPopupMessage != null) {
            this.textPopupMessage.setText((CharSequence)"");
        }
    }

    protected void bindImage() {
        String url = (String)Optional.ofNullable((Object)this.item).map(PushItem::getImageThumb).map(PreviewThumb::getUrl).orElse(null);
        if (url != null) {
            Glide.with((Context)this.context).load(url).centerCrop().diskCacheStrategy(DiskCacheStrategy.SOURCE).into(this.imagePushBotPopupImage);
            this.layoutPushBotPopupImage.setVisibility(0);
            if (this.textPopupMessage != null) {
                this.textPopupMessage.setMaxLines(this.getAttachmentTextMaxLine());
            }
        } else {
            Glide.clear((View)this.imagePushBotPopupImage);
            this.layoutPushBotPopupImage.setVisibility(8);
            if (this.textPopupMessage != null) {
                this.textPopupMessage.setMaxLines(this.getDefaultTextMaxLine());
            }
        }
    }

    protected abstract int getDefaultTextMaxLine();

    protected abstract int getAttachmentTextMaxLine();

    protected abstract void bindTitle(PushItem var1);

    protected abstract void bindContent(PushItem var1);

    protected abstract void bindButton();
}

