package com.zoyi.channel.plugin.android.network;

import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;


import static com.zoyi.channel.plugin.android.global.Const.DEFAULT_ANDROID_USER_AGENT;
import static com.zoyi.channel.plugin.android.global.Const.FORMAT_USER_AGENT_MOBILE;
import static com.zoyi.channel.plugin.android.global.Const.FORMAT_USER_AGENT_TABLET;
import static com.zoyi.channel.plugin.android.global.Const.HEADER_USER_AGENT;

public class UserAgentInterceptor implements Interceptor {

  @NonNull
  private String channelUserAgent;

  public UserAgentInterceptor() {
    channelUserAgent = String.format(
        Display.isMobile() ? FORMAT_USER_AGENT_MOBILE : FORMAT_USER_AGENT_TABLET,
        System.getProperty(DEFAULT_ANDROID_USER_AGENT),
        BuildConfig.VERSION_NAME
    );
  }

  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request()
        .newBuilder()
        .header(HEADER_USER_AGENT, channelUserAgent)
        .build();

    return chain.proceed(request);
  }
}
