/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.store2.state;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.subjects.PublishSubject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MessagesState {
    private Map<String, Message> map = new HashMap<String, Message>();
    @Nullable
    private String chatId;
    private boolean initialized;
    private PublishSubject<Collection<Message>> setterSubject = PublishSubject.create();
    private PublishSubject<Collection<Message>> upsertSubject = PublishSubject.create();

    public Subscription attachSetterEvent(Action1<Collection<Message>> action) {
        return this.setterSubject.onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe(action);
    }

    public Subscription attachUpsertEvent(Action1<Collection<Message>> action) {
        return this.upsertSubject.onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe(action);
    }

    public void attachChatId(@Nullable String chatId) {
        if (chatId != null) {
            this.chatId = chatId;
            this.map.clear();
        }
    }

    public void set(Collection<Message> messages) {
        if (messages != null) {
            this.initialized = true;
            this.addOperation(messages);
            if (this.setterSubject != null) {
                this.setterSubject.onNext(this.map.values());
            }
        }
    }

    public void add(Message message) {
        if (message != null) {
            Observable.just((Object)message).onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe(m -> this.add(Collections.singleton(m)));
        }
    }

    public void add(Collection<Message> messages) {
        if (messages != null) {
            Collection<Message> newMessages = this.addOperation(messages);
            if (this.initialized && this.upsertSubject != null && newMessages.size() > 0) {
                this.upsertSubject.onNext(newMessages);
            }
        }
    }

    @NonNull
    private Collection<Message> addOperation(Collection<Message> messages) {
        HashMap<String, Message> addMap = new HashMap<String, Message>();
        if (this.map != null && this.chatId != null) {
            for (Message message : messages) {
                String key;
                Message oldbie;
                if (message == null || !this.chatId.equals(message.getChatId()) || (oldbie = this.map.get(key = message.getId())) != null && CompareUtils.compare(oldbie.getCreatedAt(), message.getCreatedAt()) > 0) continue;
                addMap.put(key, message);
            }
            this.map.putAll(addMap);
        }
        return addMap.values();
    }

    public Map<String, Message> get() {
        return this.map;
    }

    public void clear() {
        this.chatId = null;
        this.initialized = false;
        this.map.clear();
    }

    public void reset() {
        this.chatId = null;
        this.initialized = false;
        this.map.clear();
    }
}

