package com.zoyi.channel.plugin.android.model.rest;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import com.zoyi.channel.plugin.android.model.entity.Entity;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Plugin implements Entity {
  private String id;
  private String key;
  private String color;
  private I18n welcomeNamedI18n;
  private I18n welcomeI18n;
  private Boolean mobileHideButton;
  private String borderColor;
  private String textColor;
  private String gradientColor;

  @Override
  public String getId() {
    return id;
  }

  public String getKey() {
    return key;
  }

  public String getPersonType() {
    return null;
  }

  @ColorInt
  public int getBackgroundColor() {
    try {
      return Color.parseColor(color);
    } catch (Exception ex) {
    }
    return Color.BLACK;
  }

  @ColorInt
  public int getTextColor() {
    return "black".equals(textColor) ? Color.BLACK : Color.WHITE;
  }

  public String getBorderColor() {
    return borderColor;
  }

  public int getGradientColor() {
    try {
      return Color.parseColor(gradientColor);
    } catch (Exception ex) {
    }
    return Color.BLACK;
  }

  public Boolean isHideLauncher() {
    return mobileHideButton;
  }

  public I18n getWelcomeNamedI18n() {
    return welcomeNamedI18n;
  }

  public I18n getWelcomeI18n() {
    return welcomeI18n;
  }
}
