package com.zoyi.channel.plugin.android.activity.common.watermark;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.selector2.ChannelSelector;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;

public class ChannelWatermarkView extends FrameLayout {

  private Context context;

  private View root;
  private CardView background;

  @Nullable
  private Binder binder;

  @Nullable
  private String link;

  public ChannelWatermarkView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_channel_watermark, this, true);
    background = root.findViewById(R.id.cardChannelWatermark);

    root.setBackgroundColor(Color.TRANSPARENT);

    root.setOnClickListener(v -> {
      if (link != null) {
        IntentUtils.setUrl(ChannelWatermarkView.this.context, link).startActivity();
      }
    });
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    binder = ChannelSelector.bindChannel(channel -> {
      root.setVisibility(channel.shouldShowWatermark() ? View.VISIBLE : View.GONE);

      link = String.format(
          Const.UTM_URL,
          SettingsStore.get().locale.get().toString(),
          Const.UTM_PATH_WATERMARK,
          channel.getName(),
          channel.getId()
      );
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
    }
  }

  public void setBackgroundVisibility(boolean visibility) {
    if (visibility) {
      background.setCardBackgroundColor(ResUtils.getColor(R.color.ch_pale_grey_two));
      background.setCardElevation(Utils.dpToPx(4));
    } else {
      background.setCardBackgroundColor(Color.TRANSPARENT);
      background.setCardElevation(0);
    }
  }
}
