/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push_bot;

import android.app.Activity;
import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.PushBot;
import com.zoyi.channel.plugin.android.model.wrapper.PushBotReachRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector2.PushBotSelector;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.rx.Observable;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PushBotManager {
    public static void reachPushBots(List<PushBot> pushBots) {
        final Activity topActivity = GlobalStore.get().topActivity.get();
        ChannelApiManager.call(Observable.from(pushBots).filter(PushBotSelector::canTryReach).toList().flatMap(Observable::from).flatMap(pushBot -> Observable.just((Object)pushBot).delay((long)pushBot.getTriggerDelay().intValue(), TimeUnit.SECONDS)).concatMap(pushBot -> ChannelApiManager.get().reachPushBot(pushBot.getId())).filter(PushBotReachRepo::isReach).first(), new RestSubscriber<PushBotReachRepo>(){

            @Override
            public void onError(RetrofitException error) {
                L.e("Fail to show push bot. " + error.getMessage());
            }

            @Override
            public void onSuccess(@NonNull PushBotReachRepo pushBotReachRepo) {
                if (pushBotReachRepo.isValid()) {
                    PushBotItem pushBotItem = PushBotItem.newInstance(pushBotReachRepo.getPushBot(), pushBotReachRepo.getPushBotVariant(), topActivity);
                    PushBotStore.get().pushBots.upsert(pushBotItem);
                    if (!pushBotReachRepo.isOriginState()) {
                        pushBotReachRepo.set();
                    }
                }
            }
        });
    }
}

