package com.zoyi.channel.plugin.android.view.coordinator;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.MotionEvent;

public class PaddingNestedScrollView extends NestedScrollView {

  public PaddingNestedScrollView(@NonNull Context context) {
    super(context);
  }

  public PaddingNestedScrollView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public PaddingNestedScrollView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  public boolean onTouchEvent(MotionEvent ev) {
    int y = (int) ev.getY();

    if (y < getPaddingTop() - getScrollY()) {
      switch (ev.getAction()) {
        case MotionEvent.ACTION_DOWN:
          return false;
      }
    }

    return super.onTouchEvent(ev);
  }
}
