package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Display;

import java.util.ArrayList;

/**
 * Created by mika on 8/31/16.
 */
class PhotoPickerAdapter
    extends RecyclerView.Adapter<PhotoHolder>
    implements PhotoPickerAdapterContract.View, PhotoPickerAdapterContract.Model {

  private Context context;
  @Nullable
  private OnPhotoClickListener listener;

  private ArrayList<PhotoItem> photoItems;
  private ArrayList<PhotoItem> selectedItems;

  private int itemSize;
  private int itemMargin;

  PhotoPickerAdapter(Context context) {
    this.context = context;
    this.photoItems = new ArrayList<>();
    this.selectedItems = new ArrayList<>();

    itemSize = Display.getWidth(context) / Const.COLUMNS_PHOTO_PICKER;
    itemMargin = (int) Utils.dpToPx(context, 2);
  }

  @Override
  public void setOnPhotoClickListener(OnPhotoClickListener listener) {
    this.listener = listener;
  }

  @Override
  public void notifyDataChanged() {
    notifyDataSetChanged();
  }

  @Override
  public PhotoHolder onCreateViewHolder(ViewGroup parent, int viewType) {
    return new PhotoHolder(
        LayoutInflater.from(context).inflate(R.layout.ch_plugin_item_photo_picker, parent, false),
        itemSize,
        itemMargin,
        listener);
  }

  @Override
  public void onBindViewHolder(PhotoHolder holder, int position) {
    PhotoItem photoItem = photoItems.get(position);

    holder.setValue(
        photoItem,
        position,
        selectedItems.contains(photoItem));
  }

  @Override
  public int getItemCount() {
    return photoItems.size();
  }

  @Override
  public void setPhotoItems(ArrayList<PhotoItem> photoItems) {
    this.photoItems = photoItems;
  }

  @Override
  public void refreshSelectedItems() {
    ArrayList<PhotoItem> removeItems = new ArrayList<>();

    for (PhotoItem selectedItem : selectedItems) {
      if (!photoItems.contains(selectedItem)) {
        removeItems.add(selectedItem);
      }
    }
    for (PhotoItem removeItem : removeItems) {
      selectedItems.remove(removeItem);
    }
  }

  @Override
  public int selectPhotoItem(int position, boolean checked) {
    PhotoItem photoItem = photoItems.get(position);

    if (checked) {
      if (selectedItems.size() < Const.PHOTO_SELECT_LIMIT) {
        if (!selectedItems.contains(photoItem)) {
          selectedItems.add(photoItem);
        }
      } else {
        Toast.makeText(
            context,
            ResUtils.getString(context, "ch.photo.limit_alert"),
            Toast.LENGTH_LONG
        ).show();

        return -1;
      }
    } else {
      selectedItems.remove(photoItem);
    }
    return selectedItems.size();
  }

  @Override
  public int getSelectedItemCount() {
    return selectedItems.size();
  }

  @Override
  public ArrayList<String> getPhotoPaths() {
    ArrayList<String> photoPaths = new ArrayList<>();

    for (PhotoItem photoItem : selectedItems) {
      photoPaths.add(photoItem.getPath());
    }
    return photoPaths;
  }
}
