package com.zoyi.channel.plugin.android.model.rest;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.DeviceUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.okhttp3.MediaType;
import com.zoyi.okhttp3.RequestBody;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Created by ryan on 2017. 8. 28..
 */

public class Event {

  private String name;
  private Map<String, Object> property;
  private Map<String, Object> sysProperty;

  public Event(@NonNull String name, @Nullable Map<String, Object> property) {
    this.name = name;
    this.property = property;
    this.sysProperty = new HashMap<>();

    initSysProperty(sysProperty);
  }

  private void initSysProperty(Map<String, Object> sysProperty) {
    sysProperty.put(Const.SYS_PROPERTY_PLUGIN_VERSION, BuildConfig.VERSION_NAME);

    Object url = property != null ? property.get(Const.PROPERTY_URL) : null;

    if (url instanceof String) {
      sysProperty.put(Const.SYS_PROPERTY_URL, url);
    } else {
      Activity topActivity = ChannelIO.getTopActivity();
      if (topActivity != null) {
        sysProperty.put(Const.SYS_PROPERTY_URL, topActivity.getClass().getSimpleName());
      }
    }

    Context context = ChannelIO.getAppContext();
    if (context != null) {
      sysProperty.put(Const.SYS_PROPERTY_SCREEN_WIDTH, Display.getWidth(context));
      sysProperty.put(Const.SYS_PROPERTY_SCREEN_HEIGHT, Display.getHeight(context));
    }
  }


}
