package com.zoyi.channel.plugin.android.model.etc;

import android.support.annotation.Nullable;

/**
 * Created by jerry on 2018. 2. 22..
 */

public class PushEvent {

  @Nullable
  private String chatId;
  @Nullable
  private String senderAvatarUrl;
  @Nullable
  private String senderName;
  @Nullable
  private String message;

  public PushEvent(InAppPushItem inAppPushItem) {
    this.senderName = inAppPushItem.getProfile().getName();
    this.senderAvatarUrl = inAppPushItem.getProfile().getAvatarUrl();
    this.chatId = inAppPushItem.getChatId();
    this.message = inAppPushItem.getFormattedSpanMessage().toString();
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  @Nullable
  public String getSenderAvatarUrl() {
    return senderAvatarUrl;
  }

  @Nullable
  public String getMessage() {
    return message;
  }

  @Nullable
  public String getSenderName() {
    return senderName;
  }
}
