package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Display;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by mika on 8/31/16.
 */
class PhotoPickerAdapter
    extends RecyclerView.Adapter<PhotoHolder>
    implements PhotoPickerAdapterContract.View, PhotoPickerAdapterContract.Model {

  private Context context;
  @Nullable
  private OnPhotoClickListener listener;

  private ArrayList<PhotoItem> photoItems;
  private ArrayList<String> selectedPaths;
  private Map<String, Integer> indexMap;

  private int itemSize;
  private int itemMargin;

  PhotoPickerAdapter(Context context) {
    this.context = context;
    this.photoItems = new ArrayList<>();
    this.selectedPaths = new ArrayList<>();
    this.indexMap = new HashMap<>();

    itemSize = Display.getWidth(context) / Const.COLUMNS_PHOTO_PICKER;
    itemMargin = (int) Utils.dpToPx(context, 2);
  }

  @Override
  public void setOnPhotoClickListener(OnPhotoClickListener listener) {
    this.listener = listener;
  }

  @Override
  public PhotoHolder onCreateViewHolder(ViewGroup parent, int viewType) {
    return new PhotoHolder(
        LayoutInflater.from(context).inflate(R.layout.ch_plugin_item_photo_picker, parent, false),
        itemSize,
        itemMargin,
        listener);
  }

  @Override
  public void onBindViewHolder(PhotoHolder holder, int position) {
    PhotoItem photoItem = photoItems.get(position);

    holder.setValue(
        photoItem,
        position,
        selectedPaths.contains(photoItem.getPath())
    );
  }

  @Override
  public int getItemCount() {
    return photoItems.size();
  }

  @Override
  public void setPhotoItems(ArrayList<PhotoItem> photoItems) {
    this.photoItems = photoItems;

    for (int i = 0; i < photoItems.size(); i++) {
      PhotoItem photoItem = photoItems.get(i);

      if (photoItem != null && photoItem.getPath() != null) {
        indexMap.put(photoItem.getPath(), i);
      }
    }

    notifyDataSetChanged();
  }

  @Override
  public boolean onPhotoItemClick(PhotoItem photoItem) {
    String path = photoItem.getPath();

    if (path != null) {
      if (selectedPaths.contains(path)) {
        int oldSelectIndex = selectedPaths.indexOf(path);

        if (oldSelectIndex >= 0) {
          selectedPaths.remove(oldSelectIndex);

          updateItemIndex(path);

          for (int i = oldSelectIndex; i < selectedPaths.size(); i++) {
            updateItemIndex(selectedPaths.get(i));
          }
        }
      } else if (selectedPaths.size() < Const.PHOTO_SELECT_LIMIT) {
        selectedPaths.add(path);

        updateItemIndex(path);
      } else {
        return false;
      }
    }
    return true;
  }

  private void updateItemIndex(@Nullable String path) {
    if (path != null && indexMap.containsKey(path)) {
      Integer index = indexMap.get(path);

      if (index != null && index >= 0) {
        notifyItemChanged(index);
      }
    }
  }

  @Override
  public ArrayList<String> getSelectedPaths() {
    return selectedPaths;
  }
}
