package com.zoyi.channel.plugin.android.activity.chat.view.overlayheader;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.view.handler.OnSizeChangeListener;

/**
 * Created by mika on 2018. 10. 24..
 */

public class SizeObservableRecyclerView extends RecyclerView {

  private int calculatedHeight = 0;

  @Nullable
  private OnSizeChangeListener onSizeChangeListener;

  public SizeObservableRecyclerView(Context context) {
    super(context);
  }

  public SizeObservableRecyclerView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public SizeObservableRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
    super(context, attrs, defStyle);
  }

  public void setOnSizeChangeListener(OnSizeChangeListener onSizeChangeListener) {
    this.onSizeChangeListener = onSizeChangeListener;
  }

  @Override
  protected void onLayout(boolean changed, final int l, int t, final int r, int b) {
    super.onLayout(changed, l, t, r, b);

    final int oldHeight = calculatedHeight;
    final int newHeight = b - t;

    calculatedHeight = newHeight;

    if (oldHeight != newHeight && onSizeChangeListener != null) {
      postDelayed(new Runnable() {
        @Override
        public void run() {
          if (onSizeChangeListener != null) {
            onSizeChangeListener.onSizeChange(r - l, newHeight, r - l, oldHeight);
          }
        }
      }, 1);
    }
  }

  public int getCalculatedHeight() {
    return calculatedHeight;
  }

  public int getMeasuredHeight(int width) {
    measure(
        View.MeasureSpec.makeMeasureSpec(width, View.MeasureSpec.EXACTLY),
        View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED));

    return getMeasuredHeight();
  }
}
