/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssetUtils {
    private static final String EMOJI_FILE = "emojis.min.json";
    private static final String KEY_EMOJI_NAME = "n";
    private static final String KEY_EMOJI_CONTENT = "c";
    private static Map<String, String> emojiMap;

    public static String getEmoji(Context context, String key) {
        if (emojiMap != null) {
            return emojiMap.get(key);
        }
        emojiMap = new ConcurrentHashMap<String, String>();
        try {
            InputStream inputStream = context.getAssets().open(EMOJI_FILE);
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            inputStream.close();
            JSONObject emojiJson = new JSONObject(new String(buffer, "UTF-8"));
            Iterator emojiKeys = emojiJson.keys();
            while (emojiKeys.hasNext()) {
                String category = (String)emojiKeys.next();
                JSONArray emojiCategory = emojiJson.getJSONArray(category);
                for (int i = 0; i < emojiCategory.length(); ++i) {
                    String emojiKey = emojiCategory.getJSONObject(i).getString(KEY_EMOJI_NAME);
                    String emojiValue = emojiCategory.getJSONObject(i).getString(KEY_EMOJI_CONTENT);
                    if (emojiKey == null || emojiValue == null) continue;
                    emojiMap.put(emojiKey, emojiValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return emojiMap.get(key);
    }
}

