package com.zoyi.channel.plugin.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;

/**
 * Created by jerry on 2018. 12. 13..
 */

public class MessageButtonView extends FrameLayout {

  private View root;
  private TextView textButtonTitle;

  public MessageButtonView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public MessageButtonView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public MessageButtonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_message_button, this, true);
    root.setBackgroundColor(ResUtils.getColor(R.color.ch_white));
    root.setOnTouchListener(new OnTouchListener() {
      @Override
      public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
          case MotionEvent.ACTION_DOWN:
            root.setBackgroundColor(ResUtils.getColor(R.color.ch_snow));
            break;

          case MotionEvent.ACTION_UP:
          case MotionEvent.ACTION_CANCEL:
            root.setBackgroundColor(ResUtils.getColor(R.color.ch_white));
            break;
        }
        return false;
      }
    });

    textButtonTitle = root.findViewById(R.id.ch_text_message_button_title);
  }

  public void setButtonTitle(String title) {
    textButtonTitle.setText(title);
  }

  public void setButtonClickListener(View.OnClickListener onClickListener) {
    root.setOnClickListener(onClickListener);
  }
}
