package com.zoyi.channel.plugin.android.activity.chat.view.action;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.util.Utils;

/**
 * Created by jerry on 2018. 6. 12..
 */

public class ActionButtonLayout extends LinearLayout {

  private Context context;

  @Nullable
  private LinearLayout lineLayout;

  private int LINE_MARGIN;
  private int availableWidth;
  private int parentWidth;

  public ActionButtonLayout(Context context) {
    super(context);
    init(context);
  }

  public ActionButtonLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ActionButtonLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    this.context = context;

    LINE_MARGIN = (int) Utils.dpToPx(context, 4f);
    availableWidth = -1;
  }

  public void refresh() {
    lineLayout = null;
    availableWidth = -1;
  }

  public void add(View actionButtonView) {
    int childWidth = getWidth(actionButtonView);

    if (availableWidth < childWidth) {
      lineLayout = getLineLayout(context);
      this.addView(lineLayout);

      measure(MeasureSpec.UNSPECIFIED, MeasureSpec.UNSPECIFIED);
      availableWidth = parentWidth;
    }

    if (lineLayout != null) {
      lineLayout.addView(actionButtonView);
    }

    availableWidth = Math.max(-1, availableWidth - childWidth);
  }

  public void setWidth(int width) {
    parentWidth = width;
  }

  public int getWidth(View view) {
    view.measure(MeasureSpec.UNSPECIFIED, MeasureSpec.UNSPECIFIED);
    return view.getMeasuredWidth();
  }

  public LinearLayout getLineLayout(Context context) {
    LinearLayout linearLayout = new LinearLayout(context);

    LayoutParams layoutParams = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
    layoutParams.topMargin = LINE_MARGIN;
    linearLayout.setLayoutParams(layoutParams);
    linearLayout.setGravity(Gravity.END);

    return linearLayout;
  }
}
