package com.zoyi.channel.plugin.android.activity.chat.view;

import android.content.Context;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnCountryCodeSelectorClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.util.CountryUtils;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

/**
 * Created by mika on 2018. 4. 17..
 */

public class MobileNumberProfileInputView extends LinearLayout {

  private Context context;

  private View buttonCountry;
  private CHTextView textCode;
  private WatchedEditText editPhone;
  private boolean inputFocused;

  private int countryCode;

  public MobileNumberProfileInputView(Context context) {
    super(context);
    init(context);
  }

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_mobile_input, this);
    this.context = context;

    buttonCountry = view.findViewById(R.id.ch_button_profile_item_country);
    textCode = view.findViewById(R.id.ch_text_profile_item_country);
    editPhone = (WatchedEditText) view.findViewById(R.id.ch_edit_profile_item_input_phone);

    setCountryCode(CountryUtils.getDefaultCountryCodeInt());
  }

  public void setEditTextChangedListener(EditTextChangedListener listener) {
    editPhone.setWatchedTextChangedListener(listener);
    editPhone.addTextChangedListener(new PhoneNumberFormattingTextWatcher());
  }

  public void setOnEditorActionListener(TextView.OnEditorActionListener onEditorActionListener) {
    editPhone.setOnEditorActionListener(onEditorActionListener);
  }

  public void setOnFocusChangeListener(OnFocusChangeListener listener) {
    editPhone.setOnFocusChangeListener(listener);
  }

  public void setOnCountryCodeSelectorClickListener(final OnCountryCodeSelectorClickListener listener) {
    buttonCountry.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        if (listener != null) {
          listener.onClick(getMobileNumber());
        }
      }
    });
  }

  public void setImeOption(int imeOption) {
    editPhone.setImeOptions(imeOption);
  }

  public void setSelection(int length) {
    editPhone.setSelection(length);
  }

  public void setText(String text) {
    editPhone.setText(text);
    editPhone.setSelection(text.length());
  }

  public boolean isInputFocused() {
    return editPhone.isFocused();
  }

  public void requestFocusInputView() {
    editPhone.requestFocus();
    Keyboard.open(context, editPhone);
  }

  public String getPhoneNumber() {
    return editPhone.getText().toString();
  }

  public void setCountryCode(int countryCode) {
    this.countryCode = countryCode;
    textCode.setText(String.format("+%d", countryCode));
  }

  public MobileNumber getMobileNumber() {
    return new MobileNumber(countryCode, editPhone.getText().toString());
  }

  public void setMobileNumber(int code, String phoneNumber) {
    this.setCountryCode(code);
    this.editPhone.setText(phoneNumber);
  }

  @Override
  public void setEnabled(boolean enabled) {
    this.editPhone.setEnabled(enabled);
  }
}
