/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.splunk.mint.Mint;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.Guest;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.enumerate.ChannelViewEvent;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.ChannelViewBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.push.ChannelPushClient;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.TokenSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.ChannelIOSettingsStore;
import com.zoyi.channel.plugin.android.store.DataStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.UiStateStore;
import com.zoyi.channel.plugin.android.util.BootManager;
import com.zoyi.channel.plugin.android.util.L;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

public class ChannelIO {
    private static final String MINT_DEBUG_KEY = "e72f17f4";
    private static final String MINT_PROD_KEY = "22464da6";
    private static boolean isDebugMode = false;
    private static boolean isEnabledTrackDefaultEvent = true;
    @Nullable
    private static ChannelIO channelIO;
    private Application application;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    @Nullable
    private ActivityLifecycleManager activityLifecycleManager;

    private ChannelIO(@NonNull Application application) {
        this.application = application;
        this.activityLifecycleManager = new ActivityLifecycleManager();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleManager);
        this.setUncaughtExceptionHandler();
        ChannelIOManager.create(application, this.activityLifecycleManager);
        SocketManager.create(application);
        new GoogleAdIdTask().execute(new Void[0]);
    }

    public static void initialize(@Nullable Application application) {
        if (application == null) {
            L.e("Fail to 'initialize', Application can't be NULL");
        } else if (ChannelIO.isInitializedChannelIO()) {
            L.e("Fail to 'initialize', Channel plugin already initialized");
        } else {
            channelIO = new ChannelIO(application);
        }
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings) {
        ChannelIO.boot(pluginSettings, null, null);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable OnBootListener completion) {
        ChannelIO.boot(pluginSettings, null, completion);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile) {
        ChannelIO.boot(pluginSettings, profile, null);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile, @Nullable OnBootListener completion) {
        if (channelIO != null && pluginSettings != null && pluginSettings.getPluginKey() != null) {
            channelIO.setBootSettings(pluginSettings);
            channelIO.bootProcess(pluginSettings, profile, completion);
        } else {
            L.e("Fail to 'boot', Check plugin information");
            if (completion != null) {
                completion.onCompletion(ChannelPluginCompletionStatus.NOT_INITIALIZED, null);
            }
        }
    }

    public static void shutdown() {
        if (channelIO != null) {
            channelIO.shutdownProcess();
        }
    }

    public static boolean open(@Nullable Context context) {
        return ChannelIO.open(context, true);
    }

    public static boolean open(@Nullable Context context, boolean animate) {
        return ChannelIOManager.startMessenger(context, null, animate);
    }

    public static void close() {
        ChannelIO.close(true);
    }

    public static void close(boolean animated) {
        if (channelIO != null) {
            channelIO.finishAll(animated);
        }
    }

    public static void show() {
        Store.getInstance(UiStateStore.class).setLauncherVisible(true);
        RxBus.post(new ChannelViewBus(ChannelViewEvent.UPDATE_LAUNCHER_VISIBILITY));
    }

    public static void hide() {
        Store.getInstance(UiStateStore.class).setLauncherVisible(false);
        RxBus.post(new ChannelViewBus(ChannelViewEvent.UPDATE_LAUNCHER_VISIBILITY));
    }

    public static boolean openChat(@Nullable Context context) {
        return ChannelIO.openChat(context, null);
    }

    public static boolean openChat(@Nullable Context context, @Nullable String chatId) {
        return ChannelIO.openChat(context, chatId, true);
    }

    public static boolean openChat(@Nullable Context context, @Nullable String chatId, boolean animate) {
        return ChannelIOManager.startMessenger(context, chatId, animate);
    }

    public static boolean canShowLauncher() {
        Channel channel = ChannelSelector.getCurrentChannel();
        return ChannelIO.isBooted() && channel != null && channel.canShowLauncher();
    }

    public static void initPushToken(String token) {
        Context context = ChannelIO.getAppContext();
        if (context != null) {
            PrefSupervisor.setDeviceToken(context, token);
        }
    }

    public static void handlePushNotification() {
        Context context = ChannelIO.getAppContext();
        if (context != null) {
            ChannelPushClient.handlePushNotification(context);
        }
    }

    public static void showPushNotification(Context context, Map<String, String> message) {
        if (context != null) {
            ChannelPushManager.showPushNotification(context, message);
        }
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(message);
    }

    private void setUncaughtExceptionHandler() {
        this.uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (Looper.getMainLooper().getThread() == thread) {
                    ChannelIO.this.uncaughtExceptionHandler.uncaughtException(thread, ex);
                } else if (ex instanceof RejectedExecutionException) {
                    SocketManager.reconnect();
                }
            }
        });
    }

    private void setBootSettings(ChannelPluginSettings pluginSettings) {
        isDebugMode = pluginSettings.isDebugMode();
        isEnabledTrackDefaultEvent = pluginSettings.isEnabledTrackDefaultEvent();
        if (this.application != null) {
            PrefSupervisor.setPluginLanguage((Context)this.application, pluginSettings.getLocale());
            PrefSupervisor.setPluginSetting((Context)this.application, pluginSettings);
        }
    }

    private void bootProcess(final ChannelPluginSettings pluginSettings, @Nullable Profile profile, final @Nullable OnBootListener listener) {
        if (ChannelIO.isBooted()) {
            this.shutdownProcess();
        }
        ChannelApiManager.callOnce("boot_v2", ChannelApiManager.get().getLastestPackage("com.zoyi.channel.plugin.android", "5.4.1").filter(packageInfo -> BootManager.isValidVersion(packageInfo, listener)).flatMap(__ -> BootManager.bootPlugin(pluginSettings, profile)).filter(pluginInfo -> BootManager.isValidPlugin(pluginInfo, listener)), new RestSubscriber<PluginWrapper>(){

            @Override
            public void onError(RetrofitException e) {
                BootManager.sendNetworkError(listener, e);
            }

            @Override
            public void onNext(PluginWrapper repo) {
                repo.set();
                PrefSupervisor.setBootData((Context)ChannelIO.this.application, repo.getGuest());
                Store.getInstance(ChannelIOSettingsStore.class).setPluginSettings(pluginSettings);
                Store.getInstance(UiStateStore.class).setClosedChatVisible(PrefSupervisor.isShownClosedChat((Context)ChannelIO.this.application));
                ChannelPushManager.sendTokenToChannelIO((Context)ChannelIO.this.application);
                SocketManager.setChannelId(ChannelSelector.getCurrentChannelId());
                SocketManager.connect();
                ChannelIOManager.subscribeSocket();
                RxBus.post(new CommandBus(Command.BOOT));
                RxBus.post(new ChannelViewBus(ChannelViewEvent.UPDATE_LAUNCHER_VISIBILITY));
                if (listener != null) {
                    listener.onCompletion(ChannelPluginCompletionStatus.SUCCESS, Guest.newInstance(GuestSelector.get()));
                }
            }
        });
    }

    private void shutdownProcess() {
        PrefSupervisor.clearBootData((Context)this.application);
        String jwt = TokenSelector.getJwt();
        ChannelPushManager.deleteToken((Context)this.application, jwt);
        PrefSupervisor.setJwtToken((Context)this.application, null);
        Store.destroy();
        RxBus.post(new CommandBus(Command.SHUTDOWN));
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        ChannelIOManager.release();
        ChatManager.release();
        this.releaseBugTracking();
    }

    private void finishAll(boolean animated) {
        if (this.activityLifecycleManager != null) {
            this.activityLifecycleManager.finish(animated);
        }
    }

    @Nullable
    public static Activity getTopActivity() {
        if (channelIO != null && ChannelIO.channelIO.activityLifecycleManager != null) {
            return ChannelIO.channelIO.activityLifecycleManager.getTopActivity();
        }
        return null;
    }

    private void initBugTracking(Channel channel) {
        if (this.application != null) {
            Mint.disableNetworkMonitoring();
            Mint.initAndStartSession((Application)this.application, (String)MINT_PROD_KEY);
            Mint.addExtraData((String)"plugin_version", (String)"5.4.1");
            if (channel != null) {
                Mint.addExtraData((String)"channel_id", (String)channel.getId());
                Mint.addExtraData((String)"channel_name", (String)channel.getName());
            }
        }
    }

    private void releaseBugTracking() {
        if (this.application != null) {
            Mint.clearExtraData();
            Mint.closeSession((Application)this.application);
            Mint.flush();
        }
    }

    public static void track(@NonNull @Size(min=1L, max=30L) String eventName, @Nullable Map<String, Object> eventProperty) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            L.e("Fail to track event. Event name can't be blank or null.");
            return;
        }
        if (eventName.length() > 30) {
            L.e("Fail to track event. Event name must be 30 characters or less.");
            return;
        }
        String pluginId = PluginSelector.getPluginId();
        if (pluginId == null) {
            L.e("Fail to track event. Unauthorized access.");
            return;
        }
        ChannelIOManager.track(pluginId, new Event(eventName, eventProperty));
    }

    public static boolean isInitializedChannelIO() {
        return channelIO != null;
    }

    @Nullable
    public static Context getAppContext() {
        if (channelIO != null) {
            return ChannelIO.channelIO.application.getApplicationContext();
        }
        return null;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static boolean isEnabledTrackDefaultEvent() {
        return isEnabledTrackDefaultEvent;
    }

    @Deprecated
    public static boolean isDataStored() {
        return ChannelIO.isBooted();
    }

    public static boolean isBooted() {
        return ChannelIOSelector.isBooted();
    }

    public static void updateGuest() {
        ChannelIO.updateGuest(null);
    }

    public static void updateGuest(@Nullable OnGuestUpdatedListener listener) {
        ChannelIOManager.fetchMe(listener);
    }

    public static void setChannelPluginListener(ChannelPluginListener channelPluginListener) {
        ChannelIOManager.setChannelPluginListener(channelPluginListener);
    }

    public static void clearChannelPluginListener() {
        ChannelIOManager.clearChannelPluginListener();
    }

    private class GoogleAdIdTask
    extends AsyncTask<Void, Void, String> {
        private GoogleAdIdTask() {
        }

        @Nullable
        protected String doInBackground(Void ... params) {
            try {
                AdvertisingIdClient.Info advertisingIdInfo;
                if (ChannelIO.this.application != null && (advertisingIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)ChannelIO.this.application)) != null && !advertisingIdInfo.isLimitAdTrackingEnabled()) {
                    return advertisingIdInfo.getId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        protected void onPostExecute(String adId) {
            if (adId != null) {
                Store.getInstance(DataStore.class).setAdId(adId);
            }
        }
    }
}

