package com.zoyi.channel.plugin.android.store;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.model.rest.Bot;

/**
 * Created by mika on 2018. 6. 18..
 */

public class BotStore extends CollectionStore<Bot> implements DestroyableStore {

  private String defaultBotId;

  @Nullable
  public String getDefaultBotId() {
    return defaultBotId;
  }

  public void setDefaultBot(Bot bot) {
    if (bot != null && bot.getId() != null) {
      defaultBotId = bot.getId();
    }
  }

  @NonNull
  @Override
  protected StoreType getStoreType() {
    return StoreType.BOT;
  }

  @Override
  public void clearData() {
    map.clear();
    defaultBotId = null;
  }
}
