package com.zoyi.channel.plugin.android.activity.photo_album;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.rest.File;

import java.util.ArrayList;

public class PhotoAlbumStorage {

  @Nullable
  private static PhotoAlbumStorage instance;

  public static PhotoAlbumStorage getInstance() {
    if (instance == null) {
      synchronized (PhotoAlbumStorage.class) {
        if (instance == null) {
          instance = new PhotoAlbumStorage();
        }
      }
    }
    return instance;
  }

  private ArrayList<File> files;

  private PhotoAlbumStorage() {
    files = new ArrayList<>();
  }

  public void clear() {
    files.clear();
  }

  public void release() {
    files.clear();
    instance = null;
  }

  public void addImageFile(File file) {
    if (files == null) {
      files = new ArrayList<>();
    }
    files.add(file);
  }

  public ArrayList<File> getFiles() {
    return files;
  }

}
