/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.overlayheader;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.zoyi.channel.plugin.android.view.handler.OnSizeChangeListener;

public class SizeObservableRecyclerView
extends RecyclerView {
    private int calculatedHeight = 0;
    @Nullable
    private OnSizeChangeListener onSizeChangeListener;

    public SizeObservableRecyclerView(Context context) {
        super(context);
    }

    public SizeObservableRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SizeObservableRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setOnSizeChangeListener(OnSizeChangeListener onSizeChangeListener) {
        this.onSizeChangeListener = onSizeChangeListener;
    }

    protected void onLayout(boolean changed, final int l, int t, final int r, int b) {
        int newHeight;
        super.onLayout(changed, l, t, r, b);
        final int oldHeight = this.calculatedHeight;
        this.calculatedHeight = newHeight = b - t;
        if (oldHeight != newHeight && this.onSizeChangeListener != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (SizeObservableRecyclerView.this.onSizeChangeListener != null) {
                        SizeObservableRecyclerView.this.onSizeChangeListener.onSizeChange(r - l, newHeight, r - l, oldHeight);
                    }
                }
            }, 1L);
        }
    }

    public int getCalculatedHeight() {
        return this.calculatedHeight;
    }

    public int getMeasuredHeight(int width) {
        this.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return this.getMeasuredHeight();
    }
}

