/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.observers;

import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnCompletedFailedException;
import com.zoyi.rx.exceptions.OnErrorFailedException;
import com.zoyi.rx.plugins.RxJavaHooks;

public final class SafeCompletableSubscriber
implements CompletableSubscriber,
Subscription {
    final CompletableSubscriber actual;
    Subscription s;
    boolean done;

    public SafeCompletableSubscriber(CompletableSubscriber actual) {
        this.actual = actual;
    }

    public void onCompleted() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.actual.onCompleted();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw new OnCompletedFailedException(ex);
        }
    }

    public void onError(Throwable e) {
        RxJavaHooks.onError(e);
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.actual.onError(e);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw new OnErrorFailedException(new CompositeException(e, ex));
        }
    }

    public void onSubscribe(Subscription d) {
        this.s = d;
        try {
            this.actual.onSubscribe(this);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            d.unsubscribe();
            this.onError(ex);
        }
    }

    public void unsubscribe() {
        this.s.unsubscribe();
    }

    public boolean isUnsubscribed() {
        return this.done || this.s.isUnsubscribed();
    }
}

