package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.Views;

/**
 * Created by jerry on 2018. 1. 9..
 */

public class WaterMarkLayout extends RelativeLayout {

  private View root;

  public WaterMarkLayout(Context context) {
    super(context);
    initialize(context);
  }

  public WaterMarkLayout(Context context, AttributeSet attrs) {
    super(context, attrs);
    initialize(context);
  }

  public WaterMarkLayout(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    initialize(context);
  }

  @Initializer
  public void initialize(final Context context) {
    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_watermark, this);

    final Channel channel = ChannelSelector.getCurrentChannel();
    Views.setVisibility(root, channel != null && !channel.isProMessengerPlan());

    setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        IntentUtils.setUrl(context,
            String.format(
                Const.UTM_URL,
                PrefSupervisor.getPluginLanguage(context),
                Const.UTM_PATH_WATERMARK,
                channel.getName(),
                channel.getId()))
            .startActivity();
      }
    });
  }
}
