package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonView;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.Form;
import com.zoyi.channel.plugin.android.model.TranslationInfo;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.draw.Resizer;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.zoyi.com.bumptech.glide.request.RequestListener;
import com.zoyi.com.bumptech.glide.request.target.Target;

import java.util.List;

/**
 * Created by jerry on 2018. 10. 22..
 */

public abstract class ContentMessageHolder extends TextMessageHolder {

  private View rootContentMessageFile;
  private ImageView imageContentMessageFile;
  private CHTextView textContentMessageFileName;
  private CHTextView textContentMessageFileInfo;

  private MaskableFrameLayout rootContentMessageImage;
  private MaskableFrameLayout frameContentMessageImage;
  private ImageView imageContentMessageImage;
  private ImageView imageContentMessagePlaceHolder;

  private ViewGroup rootContentMessageWebPage;
  private View layoutContentMessageWebDescription;
  private CHTextView textContentMessageWebDescriptionTitle;
  private CHTextView textContentMessageWebDescriptionUrl;
  private View layoutContentMessageWebPreview;
  private ImageView imageContentMessageWebPreview;

  private View rootContentMessageTranslation;
  private LinearLayout buttonContentMessageTranslation;
  private CHTextView textContentMessageTranslation;
  private ImageView viewContentMessageTranslationButtonArrow;
  private CircularProgressView progressContentMessageTranslation;

  private LinearLayout rootExtraContentMessageForm;
  private FormButtonLayout layoutExtraContentMessageFormButton;

  @Nullable
  private OnMessageContentClickListener onMessageContentClickListener;

  @Nullable
  protected Message message;

  protected ContentMessageHolder(
      View itemView,
      MessageType messageType,
      @Nullable final OnMessageContentClickListener onMessageContentClickListener
  ) {
    super(itemView, messageType);

    this.onMessageContentClickListener = onMessageContentClickListener;

    rootContentMessageFile = itemView.findViewById(R.id.ch_root_message_content_file);
    imageContentMessageFile = itemView.findViewById(R.id.ch_image_message_content_file_icon);
    textContentMessageFileName = itemView.findViewById(R.id.ch_text_message_content_file_name);
    textContentMessageFileInfo = itemView.findViewById(R.id.ch_text_message_content_file_info);

    rootContentMessageImage = itemView.findViewById(R.id.ch_root_message_content_image);
    imageContentMessageImage = itemView.findViewById(R.id.ch_image_message_content);
    imageContentMessagePlaceHolder = itemView.findViewById(R.id.ch_image_message_content_placeholder);
    frameContentMessageImage = itemView.findViewById(R.id.ch_frame_message_content_image);


    rootContentMessageWebPage = itemView.findViewById(R.id.ch_root_message_content_web_page);

    layoutContentMessageWebPreview = itemView.findViewById(R.id.ch_layout_message_content_web_preview);
    imageContentMessageWebPreview = itemView.findViewById(R.id.ch_image_message_content_web_preview);

    layoutContentMessageWebDescription = itemView.findViewById(R.id.ch_layout_message_content_web_description);
    textContentMessageWebDescriptionTitle = itemView.findViewById(R.id.ch_text_message_content_web_description_title);
    textContentMessageWebDescriptionUrl = itemView.findViewById(R.id.ch_text_message_content_web_description_url);

    rootContentMessageTranslation = itemView.findViewById(R.id.ch_root_message_content_translation);
    buttonContentMessageTranslation = itemView.findViewById(R.id.ch_layout_message_content_translation_button);
    textContentMessageTranslation = itemView.findViewById(R.id.ch_text_content_message_translation);
    viewContentMessageTranslationButtonArrow = itemView.findViewById(R.id.ch_image_content_message_translation_arrow);
    progressContentMessageTranslation = itemView.findViewById(R.id.ch_progress_content_message_translation);

    rootExtraContentMessageForm = itemView.findViewById(R.id.ch_root_extra_content_form);
    layoutExtraContentMessageFormButton = itemView.findViewById(R.id.ch_layout_extra_content_form_button);

    // Set file description click event
    rootContentMessageFile.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        if (onMessageContentClickListener != null && message != null) {
          onMessageContentClickListener.onFileClick(message.getFile());
        }
      }
    });

    // Set image click event
    imageContentMessageImage.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        if (onMessageContentClickListener != null && message != null && message.getFile() != null) {
          onMessageContentClickListener.onImageClick(message.getFile());
        }
      }
    });

    // Set web page description click event
    rootContentMessageWebPage.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        if (onMessageContentClickListener != null && message != null && message.getWebPage() != null) {
          onMessageContentClickListener.onWebPageClick(message.getWebPage().getUrl());
        }
      }
    });

    // Set translation button click event
    if (textContentMessageTranslation != null) {
      textContentMessageTranslation.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          if (onMessageContentClickListener != null && message != null) {
            TranslationInfo translationInfo = TranslationSelector.get(TranslationInfo.createId(
                message.getId(),
                PrefSupervisor.getPluginLanguage(context)));

            if (translationInfo == null || translationInfo.getState() != TranslationState.PROGRESS) {
              onMessageContentClickListener.onTranslationButtonClick(message);
            }
          }
        }
      });
    }
  }

  public void bind(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
    super.bind(message, messageType, isConnectedMessage);
    this.message = message;
  }

  @Override
  protected void resetViews() {
    super.resetViews();

    imageContentMessagePlaceHolder.setVisibility(View.GONE);

    layoutContentMessageWebPreview.setVisibility(View.GONE);
    layoutContentMessageWebDescription.setVisibility(View.GONE);
  }

  // File

  protected void setFileDescription(File file) {
    String fileSize = Utils.getProperBytes(file.getSize());
    String fileType = "";
    String extension = file.getExtension();

    if (!"default".equals(extension) && !TextUtils.isEmpty(extension)) {
      fileType = String.format(" · %s", extension.substring(0, 1).toUpperCase() + extension.substring(1));
    }

    rootContentMessageFile.setVisibility(View.VISIBLE);

    textContentMessageFileName.setText(file.getFilename());
    textContentMessageFileInfo.setText(String.format("%s%s", fileSize, fileType));
    imageContentMessageFile.setImageResource(ResUtils.getFileIconResourceId(file));
  }

  // Image

  protected void setImage(Previewable previewable) {
    if (previewable == null) {
      return;
    }

    rootContentMessageImage.setVisibility(View.VISIBLE);
    imageContentMessagePlaceHolder.setVisibility(View.VISIBLE);

    Point previewImageSize = Utils.resizeImage(context, new Point(previewable.getWidth(), previewable.getHeight()), false);
    Resizer.size(frameContentMessageImage, previewImageSize.x, previewImageSize.y);

    Glide.with(itemView.getContext())
        .load(previewable.getUrl())
        .diskCacheStrategy(DiskCacheStrategy.SOURCE)
        .override(previewImageSize.x, previewImageSize.y)
        .centerCrop()
        .listener(new RequestListener<String, GlideDrawable>() {
          @Override
          public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
            return false;
          }

          @Override
          public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
            imageContentMessagePlaceHolder.setVisibility(View.GONE);
            return false;
          }
        })
        .into(imageContentMessageImage);
  }

  // Web page

  protected void setWebPage(final WebPage webPage) {

    rootContentMessageWebPage.setVisibility(View.VISIBLE);

    // Web description
    layoutContentMessageWebDescription.setVisibility(View.VISIBLE);

    if (!TextUtils.isEmpty(webPage.getTitle())) {
      textContentMessageWebDescriptionTitle.setText(webPage.getTitle());
    } else {
      textContentMessageWebDescriptionTitle.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
    }

    if (!TextUtils.isEmpty(webPage.getDescription())) {
      textContentMessageWebDescriptionUrl.setText(webPage.getTitle());
    } else {
      textContentMessageWebDescriptionUrl.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
    }

    // Web preview
    if (webPage.getPreviewThumb() != null) {
      layoutContentMessageWebPreview.setVisibility(View.VISIBLE);

      Point previewImageSize = Utils.resizeImage(context, new Point(webPage.getPreviewThumb().getWidth(), webPage.getPreviewThumb().getHeight()), true);
      Resizer.size(layoutContentMessageWebPreview, previewImageSize.x, previewImageSize.y);

      Glide.with(itemView.getContext())
          .load(webPage.getPreviewThumb().getUrl())
          .diskCacheStrategy(DiskCacheStrategy.SOURCE)
          .override(previewImageSize.x, previewImageSize.y)
          .centerCrop()
          .into(imageContentMessageWebPreview);
    }
  }

  // Translation

  protected void setTranslationButton(final Message message, boolean isConnectedMessage) {
    rootContentMessageTranslation.setVisibility(View.VISIBLE);

    CharSequence messageContent = message.getFormattedSpanMessage();

    TranslationInfo translationInfo = TranslationSelector.get(TranslationInfo.createId(
        message.getId(),
        PrefSupervisor.getPluginLanguage(context)));

    TranslationState translationState = translationInfo == null ? TranslationState.ORIGIN : translationInfo.getState();

    switch (translationState) {
      case ORIGIN:
        setTranslateButtonWithoutProgress("show_translate", false);
        break;

      case TRANSLATED:
        setTranslateButtonWithoutProgress("undo_translate", true);
        if (translationInfo != null) {
          messageContent = translationInfo.getTranslatedMessage();
        }
        break;

      case PROGRESS:
        buttonContentMessageTranslation.setVisibility(View.INVISIBLE);
        progressContentMessageTranslation.setVisibility(View.VISIBLE);
        break;
    }

    setHostMessageText(messageContent, isConnectedMessage);
  }

  private void setTranslateButtonWithoutProgress(String textKey, boolean isTranslated) {
    buttonContentMessageTranslation.setVisibility(View.VISIBLE);
    progressContentMessageTranslation.setVisibility(View.GONE);
    textContentMessageTranslation.setTextByKey(textKey);
    Views.setVisibility(viewContentMessageTranslationButtonArrow, isTranslated);
  }

  // Form

  protected void setFormMessage(@NonNull Message message) {
    Form form = message.getForm();

    if (form != null && ListUtils.hasItems(form.getInputs())) {
      rootExtraContentMessageForm.setVisibility(View.VISIBLE);

      layoutExtraContentMessageFormButton.removeAllViews();
      layoutExtraContentMessageFormButton.refresh();

      // ch_plugin_item_message_extra_content_form paddingStart 값과 일치해야함
      layoutExtraContentMessageFormButton.setWidth(Utils.getWindowSize(context).x - ((int) Utils.dpToPx(context, 40f)));

      for (ActionInput actionInput : form.getInputs()) {
        FormButtonView formButtonView = new FormButtonView(context, form.getType(), actionInput, onMessageContentClickListener);
        layoutExtraContentMessageFormButton.add(formButtonView);
      }
    }
  }

  protected void setSupportBotMessage(List<ActionInput> actions) {
    if (ListUtils.hasItems(actions)) {
      rootExtraContentMessageForm.setVisibility(View.VISIBLE);

      layoutExtraContentMessageFormButton.removeAllViews();
      layoutExtraContentMessageFormButton.refresh();

      // ch_plugin_item_message_extra_content_form paddingStart 값과 일치해야함
      layoutExtraContentMessageFormButton.setWidth(Utils.getWindowSize(context).x - ((int) Utils.dpToPx(context, 40f)));

      for (ActionInput actionInput : actions) {
        FormButtonView formButtonView = new FormButtonView(context, Const.FORM_ACTION_TYPE_SUPPORT_BOT, actionInput, onMessageContentClickListener);
        layoutExtraContentMessageFormButton.add(formButtonView);
      }
    }
  }
}
