/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.ChannelLauncherView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.event.ChannelViewBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.StoreBus;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;
import com.zoyi.channel.plugin.android.push_bot.OnPushBotClickListener;
import com.zoyi.channel.plugin.android.selector.ChannelIOSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.UiStateSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.view.popup.InAppPushView;
import com.zoyi.channel.plugin.android.view.popup.PushBotPopupView;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

class ChannelView
extends FrameLayout
implements OnPushBotClickListener {
    private Context context;
    private ChannelLauncherView channelLauncherView;
    private PushBotPopupView pushBotPopupView;
    private InAppPushView inAppPushView;
    @Nullable
    private Subscription subscription;

    public ChannelView(Context context) {
        super(context);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this, true);
        this.channelLauncherView = (ChannelLauncherView)view.findViewById(R.id.ch_view_launcher);
        this.pushBotPopupView = (PushBotPopupView)view.findViewById(R.id.ch_view_push_bot_popup);
        this.inAppPushView = (InAppPushView)view.findViewById(R.id.ch_view_in_app_push);
        this.pushBotPopupView.setPushBotClickListener(this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (ChannelIO.isBooted()) {
            this.channelLauncherView.initialize();
        }
        this.subscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (o instanceof CommandBus) {
                    CommandBus commandBus = (CommandBus)o;
                    switch (commandBus.getCommand()) {
                        case BOOT: {
                            ChannelView.this.setVisibility(0);
                            ChannelView.this.channelLauncherView.initialize();
                            break;
                        }
                        case SHUTDOWN: {
                            ChannelView.this.setVisibility(8);
                            ChannelView.this.inAppPushView.hide();
                            ChannelView.this.pushBotPopupView.hide();
                            ChannelView.this.channelLauncherView.hide();
                        }
                    }
                }
                if (o instanceof ChannelViewBus) {
                    ChannelViewBus channelViewBus = (ChannelViewBus)o;
                    switch (channelViewBus.getChannelViewEvent()) {
                        case UPDATE_LAUNCHER_VISIBILITY: {
                            if (UiStateSelector.canShowLauncher()) {
                                if (!ChannelView.this.channelLauncherView.isVisible() && CompareUtils.isSameActivity(ChannelView.this.context, (Context)ChannelIO.getTopActivity())) {
                                    ChannelView.this.trackPageViewEvent();
                                }
                                ChannelView.this.channelLauncherView.show();
                                break;
                            }
                            ChannelView.this.channelLauncherView.hide();
                            break;
                        }
                        case SHOW_PUSH_BOT: {
                            if (!CompareUtils.isSameActivity(ChannelView.this.context, (Context)ChannelIO.getTopActivity()) || channelViewBus.getData() == null || !(channelViewBus.getData() instanceof PushBotItem)) break;
                            PushBotItem pushBotItem = (PushBotItem)channelViewBus.getData();
                            ChannelView.this.inAppPushView.hide();
                            ChannelView.this.pushBotPopupView.show(pushBotItem);
                            break;
                        }
                        case SHOW_IN_APP_PUSH: {
                            if (!UiStateSelector.canShowInAppPush(ChannelView.this.context) || channelViewBus.getData() == null || !(channelViewBus.getData() instanceof InAppPushItem)) break;
                            ChannelView.this.pushBotPopupView.hide();
                            ChannelView.this.inAppPushView.show((InAppPushItem)channelViewBus.getData());
                        }
                    }
                }
                if (o instanceof StoreBus) {
                    StoreBus storeBus = (StoreBus)o;
                    if (CompareUtils.exists((Comparable)((Object)storeBus.getStoreType()), (Comparable[])new StoreType[]{StoreType.USER, StoreType.VEIL}) && storeBus.getEntity() != null && storeBus.getEntity() instanceof Guest) {
                        Guest guest = (Guest)storeBus.getEntity();
                        ChannelView.this.channelLauncherView.updateLauncherBadgeCount(guest.getAlert());
                    }
                    if (storeBus.getStoreType() == StoreType.PLUGIN) {
                        ChannelView.this.channelLauncherView.setLauncherStyle();
                    }
                    if (storeBus.getStoreType() == StoreType.PUSH_BOT_ITEM) {
                        ChannelView.this.channelLauncherView.updateLauncherBadgeCount(CounterSelector.getTotalCounter());
                    }
                }
            }
        });
    }

    private void trackPageViewEvent() {
        String pluginId = PluginSelector.getPluginId();
        if (pluginId != null && ChannelIOSelector.isEnabledTrackDefaultEvent()) {
            ChannelIOManager.trackPageView(this.context, pluginId);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
    }

    @Override
    public void onPushBotClick(@NonNull String pushBotId) {
        this.startPushBotChat(pushBotId);
    }

    @Override
    public void onPushBotContentsClick(@NonNull String pushBotId, @Nullable String redirectUrl) {
        if (redirectUrl != null) {
            Executor.executeRedirectUrlAction(this.context, redirectUrl);
        } else {
            this.startPushBotChat(pushBotId);
        }
    }

    private void startPushBotChat(@NonNull String pushBotId) {
        IntentUtils.setNextActivity(this.context, UserChatListActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).putExtra("pushBotId", pushBotId).startActivity();
    }
}

