package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.UserStore;
import com.zoyi.channel.plugin.android.store.VeilStore;
import com.zoyi.channel.plugin.android.util.TimeUtils;

import java.util.Map;

/**
 * Created by mika on 2018. 6. 19..
 */

public class GuestSelector {

  @Nullable
  public static Guest get() {
    User user = Store.getInstance(UserStore.class).get();
    Veil veil = Store.getInstance(VeilStore.class).get();

    if (user != null) {
      return user;
    }
    return veil;
  }

  @NonNull
  public static boolean isNamed() {
    Guest guest = get();
    if (guest != null) {
      return guest.isNamed();
    }
    return false;
  }

  @Nullable
  public static String getName() {
    Guest guest = get();
    if (guest != null) {
      return guest.getName();
    }
    return null;
  }

  @NonNull
  public static String getMobileNumber() {
    Guest guest = get();
    if (guest != null && guest.getMobileNumber() != null) {
      return guest.getMobileNumber();
    }
    return "";
  }

  public static long getCreatedAt() {
    Guest guest = get();
    if (guest != null) {
      return guest.getCreatedAt();
    }
    return 0L;
  }

  public static long getUpdatedAt() {
    Guest guest = get();
    if (guest != null) {
      return guest.getUpdatedAt();
    }
    return 0L;
  }

  @Nullable
  public static Map<String, Object> getProfile() {
    Guest guest = get();
    if (guest != null) {
      return guest.getProfile();
    }
    return null;
  }

  @Nullable
  public static Object getProfileValue(String key) {
    Guest guest = get();
    if (guest != null) {
      return guest.getProfileValue(key);
    }
    return null;
  }

  @Nullable
  public static String getPersonType() {
    Guest guest = get();
    if (guest != null) {
      return guest.getPersonType();
    }
    return null;
  }

  @Nullable
  public static String getSegment() {
    Guest guest = get();
    if (guest != null) {
      return guest.getSegment();
    }
    return null;
  }

  @Nullable
  public static String getCountry() {
    Guest guest = get();
    if (guest != null) {
      return guest.getCountry();
    }
    return null;
  }

  @Nullable
  public static String getCity() {
    Guest guest = get();
    if (guest != null) {
      return guest.getCity();
    }
    return null;
  }

  @Nullable
  public static String getId() {
    if (getUserId() != null) {
      return getUserId();
    }
    return getVeilId();
  }

  @Nullable
  public static String getVeilId() {
    String veilId = Store.getInstance(VeilStore.class).getVeilId();
    if (veilId != null) {
      return veilId;
    }
    return PrefSupervisor.getVeilId(ChannelIO.getAppContext());
  }

  @Nullable
  public static String getUserId() {
    User user = Store.getInstance(UserStore.class).get();

    if (user != null) {
      return user.getId();
    }
    return null;
  }

}
