/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.channel.plugin.android.model.rest.WorkingTime;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class Channel
implements Entity,
ProfileEntity {
    public static final String EXPECTED_RESPONSE_DELAY_INSTANT = "instant";
    public static final String EXPECTED_RESPONSE_DELAY_NORMAL = "normal";
    public static final String EXPECTED_RESPONSE_DELAY_DELAYED = "delayed";
    public static final String PLAN_PRO = "pro";
    private String id;
    private String name;
    private String timeZone;
    private WorkingTime workingTime;
    private TimeRange lunchTime;
    private String homepageUrl;
    private String phoneNumber;
    private String messengerPlan;
    private String pushBotPlan;
    private String supportBotPlan;
    private Boolean blocked;
    private Boolean requestGuestInfo;
    private String expectedResponseDelay;
    private String workingType;
    private String awayOption;
    private Boolean trial;
    private String avatarUrl;
    private Boolean working;
    public static final String CLASSNAME = "Channel";

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getAwayOption() {
        return this.awayOption;
    }

    public String getWorkingType() {
        return this.workingType;
    }

    @Override
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public boolean isWorking() {
        return this.working;
    }

    public String getWorkingTime(Context context) {
        String launch;
        String string2 = launch = this.lunchTime != null ? String.format("%s: %s", ResUtils.getString(context, "ch.out_of_work.lunch_time"), TimeUtils.getTimeRangeString(this.lunchTime)) : null;
        if (this.workingTime != null) {
            String work = this.workingTime.getMessage(context);
            if (launch != null) {
                return String.format("Timezone: %s<br><br>%s<br><br>%s", this.timeZone, work, launch);
            }
            return String.format("Timezone: %s<br><br>%s", this.timeZone, work);
        }
        return "";
    }

    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getMessengerPlan() {
        return this.messengerPlan;
    }

    public String getPushBotPlan() {
        return this.pushBotPlan;
    }

    public String getSupportBotPlan() {
        return this.supportBotPlan;
    }

    public boolean isRequestGuestInfo() {
        return this.requestGuestInfo;
    }

    public String getExpectedResponseDelay() {
        return this.expectedResponseDelay;
    }

    public boolean isTrial() {
        if (this.trial == null) {
            return false;
        }
        return this.trial;
    }

    public boolean isProMessengerPlan() {
        return PLAN_PRO.equals(this.getMessengerPlan());
    }

    public boolean canUseMobileSdk() {
        return this.blocked == false && (this.isTrial() || this.isProMessengerPlan());
    }
}

