/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListAdapter;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListPresenter;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatListContract;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.AlertDialogListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.BottomFloatingActionLayout;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

public class UserChatListActivity
extends BaseActivity
implements View.OnClickListener,
UserChatListContract.View {
    private View rootView;
    private View emptyLayout;
    private View reconnectLayout;
    private RecyclerView chatList;
    private BottomFloatingActionLayout bottomFloatingActionLayout;
    private FloatingActionButton fab;
    private LinearLayoutManager layoutManager;
    private UserChatListAdapter adapter;
    private UserChatListContract.Presenter presenter;
    @Nullable
    private String redirectChatId;
    protected boolean animateOnInit = true;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_user_chat_list);
        if (this.getIntent() != null) {
            this.redirectChatId = this.getIntent().getStringExtra("chatId");
            this.animateOnInit = this.getIntent().getBooleanExtra("animated", true);
        }
        this.rootView = this.findViewById(R.id.root_view);
        this.emptyLayout = this.findViewById(R.id.layout_empty);
        this.reconnectLayout = this.findViewById(R.id.layout_reconnect);
        this.fab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.chatList = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.bottomFloatingActionLayout = (BottomFloatingActionLayout)this.findViewById(R.id.ch_layout_chat_list_bottom_frame);
        this.fab.setOnClickListener(this);
        if (this.bigBar != null) {
            this.bigBar.withActivity(this).addMenu(MenuButton.ActionType.SETTINGS, BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).build();
        }
        this.adapter = new UserChatListAdapter();
        this.presenter = new UserChatListPresenter((Context)this);
        this.presenter.setView(this);
        this.presenter.setAdapterView(this.adapter);
        this.presenter.setAdapterModel(this.adapter);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.chatList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.chatList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.chatList.setItemAnimator(null);
        this.chatList.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.chatList.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(this.layoutManager, 1, this.chatList){

            @Override
            public void scrolledInList() {
                UserChatListActivity.this.bottomFloatingActionLayout.hide();
            }

            @Override
            public void scrollAttachedToBottom() {
                UserChatListActivity.this.bottomFloatingActionLayout.show();
            }

            @Override
            public void refresh() {
            }
        });
        this.bottomFloatingActionLayout.setRecyclerView(this.chatList);
        this.setStyle();
        if (SocketManager.isError()) {
            this.setErrorView(true);
        }
        this.presenter.refresh();
    }

    private void setStyle() {
        Channel channel = ChannelSelector.getCurrentChannel();
        Plugin plugin = PluginSelector.getPlugin();
        if (channel == null || plugin == null) {
            this.finish();
        } else {
            if (this.bigBar != null) {
                this.bigBar.setTitle(channel.getName());
            }
            this.setFabTheme();
            this.fab.attachToRecyclerView(this.chatList);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        block0 : switch (requestCode) {
            case 3002: {
                if (resultCode == 23) {
                    this.presenter.refresh();
                }
                this.presenter.redrawList();
                break;
            }
            case 21: {
                switch (resultCode) {
                    case 22: {
                        this.startChat(null, false, true, true);
                        break block0;
                    }
                    case 23: {
                        this.presenter.refresh();
                        break block0;
                    }
                    case 24: {
                        this.finish();
                    }
                }
            }
        }
    }

    @Override
    protected void onStart() {
        ChannelPushManager.sendTokenToChannelIO(ChannelIO.getAppContext());
        super.onStart();
    }

    private void setFabTheme() {
        this.fab.setColorNormal(ColorSelector.getBackgroundColor());
        this.fab.setColorPressed(Utils.addBlackMask(ColorSelector.getBackgroundColor()));
        this.fab.setColorRipple(-1);
        this.fab.setImageResource(ColorSelector.getTextColor() == -16777216 ? R.drawable.ch_plugin_ic_add_black_24dp : R.drawable.ch_plugin_ic_add_white_24dp);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.fab) {
            this.startChat(null);
        }
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case REFRESH: {
                if (this.bigBar != null) {
                    this.bigBar.setMenuState(MenuButton.ActionType.REFRESH, MenuButton.MenuState.HIDDEN);
                }
                this.presenter.refresh();
                break;
            }
            case SETTINGS: {
                IntentUtils.setNextActivity((Context)this, SettingsActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).startActivityForResult(3002);
            }
        }
        super.optionClicked(actionType);
    }

    @Override
    public void userChatsFetched(UserChatsWrapper userChatsWrapper, boolean init) {
        if (this.redirectChatId != null) {
            this.startChat(this.redirectChatId, true, this.animateOnInit, false);
            this.redirectChatId = null;
        } else if (this.adapter.getItemCount() <= 1 && init) {
            if (this.adapter.getItemCount() == 0) {
                this.startChat(null, true, this.animateOnInit, false);
            } else {
                String chatId = this.adapter.getChatId(0);
                this.startChat(chatId, true, this.animateOnInit, false);
            }
        }
        this.setViewVisibility();
    }

    @Override
    public void startChat(@Nullable String chatId) {
        this.startChat(chatId, false, true, false);
    }

    private void startChat(@Nullable String chatId, boolean redirect, boolean animate, boolean force) {
        Transition transition = !animate ? Transition.NONE : (redirect ? Transition.SLIDE_FROM_BOTTOM : Transition.SLIDE_FROM_RIGHT);
        if (force || this.isActivityFocused) {
            this.presenter.fetchPreloadData(chatId, transition);
        }
    }

    @Override
    public void setErrorView(boolean show) {
        if (this.bigBar != null) {
            this.bigBar.setMenuState(MenuButton.ActionType.REFRESH, show ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
        }
        Views.setVisibility(this.reconnectLayout, show);
    }

    @Override
    public void showDeleteUserChatDialog(final String chatId) {
        UIUtils.showAlertDialog((Context)this, ResUtils.getString((Context)this, "ch.chat.delete_description"), true, new AlertDialogListener(){

            @Override
            public void onPositive() {
                UserChatListActivity.this.presenter.removeUserChat(chatId);
            }
        });
    }

    @Override
    public void completeRemoveChat() {
        this.hideProgress();
        this.setViewVisibility();
    }

    @Override
    public void successFetchPreloadData(String chatId, Transition transition) {
        IntentUtils.setNextActivity((Context)this, ChatActivity.class).putExtra("chatId", chatId).setTransition(transition).startActivityForResult(21);
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(Entity entity, boolean upsert) {
        this.presenter.receiveData(entity, upsert);
        this.setViewVisibility();
    }

    @Override
    public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
        if (StoreType.PLUGIN == storeType) {
            this.setFabTheme();
        }
        this.presenter.receiveStoreEvent(storeType, updateType, entity);
    }

    private void setViewVisibility() {
        this.emptyLayout.setVisibility(UIUtils.getVisible(!this.hasUserChat(), true));
        this.chatList.setVisibility(UIUtils.getVisible(this.hasUserChat(), true));
    }

    private boolean hasUserChat() {
        return this.adapter.getItemCount() > 0;
    }

    @Override
    @AnimRes
    protected int getExistAnimOfFinish() {
        return R.anim.ch_plugin_slide_out_bottom;
    }
}

