/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ConnectableMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import java.util.Map;

public class SendingMessageItem
extends ConnectableMessageItem
implements MessageItem {
    @Nullable
    private String chatId;
    @Nullable
    private String message;
    @Nullable
    private String mediaFilePath;
    private String requestId;
    private boolean isMediaFile;
    private boolean sending;
    private Long createdAt;
    @Nullable
    private Map<String, String> submit;
    private static int count = 0;

    public SendingMessageItem(String requestId, Long createdAt) {
        this.requestId = requestId;
        this.createdAt = createdAt;
    }

    public SendingMessageItem(@Nullable String chatId, boolean isMediaFile) {
        this.requestId = "";
        this.createdAt = 0L;
        this.chatId = chatId;
        this.isMediaFile = isMediaFile;
        this.sending = true;
        this.refreshCreatedAt();
    }

    @Override
    public Long getPrimaryKey() {
        return this.createdAt;
    }

    @Override
    public String getSecondaryKey() {
        return this.requestId;
    }

    @Nullable
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public MessageType getType() {
        return MessageType.SENDING;
    }

    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    public boolean isSending() {
        return this.sending;
    }

    public void setSending(boolean sending) {
        this.sending = sending;
    }

    public boolean isMediaFile() {
        return this.isMediaFile;
    }

    @Nullable
    public static SendingMessageItem create(String requestId) {
        if (requestId == null) {
            return null;
        }
        try {
            return new SendingMessageItem(requestId, Long.parseLong(requestId));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    @Nullable
    public String getMediaFilePath() {
        return this.mediaFilePath;
    }

    public void setMediaFilePath(@Nullable String mediaFilePath) {
        this.mediaFilePath = mediaFilePath;
    }

    @Override
    public Long getCreatedAt() {
        return this.createdAt / 100L;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @Nullable
    public Map<String, String> getSubmit() {
        return this.submit;
    }

    public void setSubmit(Map<String, String> submit) {
        this.submit = submit;
    }

    public void refreshCreatedAt() {
        long now = TimeUtils.getCurrentTime() * 100L + (long)(count % 100);
        this.requestId = String.valueOf(now);
        this.createdAt = now;
        count = (count + 1) % 100;
    }

    @Override
    public boolean isSamePerson(@NonNull ConnectableMessageItem item) {
        if (item instanceof SendingMessageItem) {
            return true;
        }
        if (item instanceof ChatMessageItem) {
            return ((ChatMessageItem)item).getType() == MessageType.GUEST;
        }
        return false;
    }
}

