package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.DataSelector;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.okhttp3.RequestBody;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by jerry on 2018. 10. 17..
 */

public class BootManager {

  public static Map<String, String> createBootHeader() {
    Map<String, String> headers = new HashMap<>();

    String veilId = GuestSelector.getVeilId();

    if (!TextUtils.isEmpty(veilId)) {
      headers.put(Const.X_VEIL_ID, veilId.substring(0, 16));
    }

    return headers;
  }

  public static RequestBody createBootBody(ChannelPluginSettings pluginSettings, @Nullable Profile profile) {
    Map<String, Object> bodyMap = new HashMap<>();

    // User id
    bodyMap.put(Const.PROFILE_USER_ID_KEY, pluginSettings.getUserId());

    // profile
    if (profile != null) {
      Map<String, Object> profileMap = new HashMap<>();

      profileMap.put(Const.PROFILE_NAME_KEY, profile.getName());
      profileMap.put(Const.PROFILE_AVATAR_URL_KEY, profile.getAvatarUrl());
      profileMap.put(Const.PROFILE_MOBILE_NUMBER_KEY, profile.getMobileNumber());
      profileMap.put(Const.PROFILE_EMAIL_KEY, profile.getEmail());

      for (Map.Entry<String, Object> entry : profile.getProperty().entrySet()) {
        profileMap.put(entry.getKey(), entry.getValue());
      }

      bodyMap.put(Const.PROFILE_KEY, profileMap);
    }

    // Sys profile
    Map<String, String> sysProfileMap = new HashMap<>();

    sysProfileMap.put(Const.SYSTEM_PROFILE_PLATFORM_KEY, Const.SYSTEM_PROFILE_PLATFORM_ANDROID_VALUE);
    sysProfileMap.put(Const.SYSTEM_PROFILE_VERSION_KEY, BuildConfig.CHANNEL_IO_VERSION);

    if (DataSelector.getAdId() != null) {
      sysProfileMap.put(Const.SYSTEM_PROFILE_AD_ID_KEY, DataSelector.getAdId());
    }

    String wId = DeviceUtils.getWId(ChannelIO.getAppContext());
    if (wId != null) {
      sysProfileMap.put(Const.SYSTEM_PROFILE_W_ID_KEY, wId);
    }

    bodyMap.put(Const.SYSTEM_PROFILE_KEY, sysProfileMap);

    return RequestUtils.form(bodyMap).create();
  }

  public static boolean isValidVersion(PackageWrapper packageWrapper, OnBootListener onBootListener) {

    if (packageWrapper == null) {
      if (onBootListener != null) {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
      }
      return false;
    }

    if (packageWrapper.isNeedToUpgrade()) {
      if (onBootListener != null) {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.NOT_AVAILABLE_VERSION, null);
      }
      return false;
    }

    return true;
  }

  public static boolean isValidBootResult(PluginWrapper pluginWrapper, OnBootListener onBootListener) {

    if (pluginWrapper == null || !pluginWrapper.isValid()) {
      if (onBootListener != null) {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
      }
      return false;
    }

    if (!pluginWrapper.canUseMobileSDK()) {
      if (onBootListener != null) {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.REQUIRE_PAYMENT, null);
      }
      return false;
    }

    return true;
  }

  public static void sendNetworkError(OnBootListener onBootListener, RetrofitException exception) {
    if (onBootListener != null) {
      String errorMessage = Const.ERROR_UNKNOWN;
      if (exception != null) {
        ChannelPluginCompletionStatus status;
        errorMessage = exception.getMessage();

        if (exception.is4xxClientError()) {
          status = ChannelPluginCompletionStatus.ACCESS_DENIED;
        } else if (exception.is5xxServerError()) {
          status = ChannelPluginCompletionStatus.SERVICE_UNDER_CONSTRUCTION;
        } else if (exception.isConnectionTimeOutError()) {
          status = ChannelPluginCompletionStatus.NETWORK_TIMEOUT;
        } else if (exception.isHttpError()) {
          status = ChannelPluginCompletionStatus.NOT_INITIALIZED;
        } else {
          status = ChannelPluginCompletionStatus.UNKNOWN_ERROR;
        }

        onBootListener.onCompletion(status, null);
      } else {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.UNKNOWN_ERROR, null);
      }

      L.e(errorMessage);
    }
  }
}
