package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.LauncherConfig;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.store.*;

/**
 * Created by mika on 2018. 6. 20..
 */

public class ChannelIOSelector extends BaseSelector {

  public static boolean isBooted() {
    Plugin plugin = Store.getInstance(PluginStore.class).get();
    Channel channel = Store.getInstance(ChannelStore.class).get();
    User user = Store.getInstance(UserStore.class).get();
    Veil veil = Store.getInstance(VeilStore.class).get();

    return plugin != null && channel != null && channel.canUseMobileSdk() && (user != null || veil != null);
  }

  static String[] getBlockFilters() {
    return Store.getInstance(ChannelIOSettingsStore.class).getBlockFilters();
  }

  @Nullable
  public static LauncherConfig getLauncherConfig() {
    ChannelPluginSettings settings = Store.getInstance(ChannelIOSettingsStore.class).getSettings();

    if (settings != null) {
      return settings.getLauncherConfig();
    } else {
      return null;
    }
  }
}
