package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.SupportBotEntry;
import com.zoyi.channel.plugin.android.selector.BotSelector;

/**
 * Created by mika on 2018. 10. 26..
 */

public class SupportBotMessageItem implements MessageItem {

  @NonNull
  private Message message;
  @NonNull
  private SupportBotEntry supportBotEntry;

  public SupportBotMessageItem(@NonNull SupportBotEntry supportBotEntry, Long timestamp) {
    this.supportBotEntry = supportBotEntry;

    String textMessage = supportBotEntry.getStep() != null ? supportBotEntry.getStep().getMessage() : null;
    this.message = new Message(textMessage, Const.BOT, BotSelector.getDefaultBotId(), timestamp);
  }

  @NonNull
  public Message getMessage() {
    return message;
  }

  @NonNull
  public SupportBotEntry getSupportBotEntry() {
    return supportBotEntry;
  }

  @Nullable
  public String getSupportBotId() {
    if (supportBotEntry.getSupportBot() != null && supportBotEntry.getSupportBot().getId() != null) {
      return supportBotEntry.getSupportBot().getId();
    }
    return null;
  }

  @Override
  public Long getPrimaryKey() {
    return 0L;
  }

  @Override
  public String getSecondaryKey() {
    return "SupportBotMessageItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.SUPPORT_BOT;
  }
}
