package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.SupportBotEntry;

import java.util.Collection;
import java.util.List;

public interface ChatAdapterContract {

  interface View {

    void setOnProfileUpdateListener(OnProfileUpdateListener onProfileUpdateListener);
    void setOnMessageContentClickListener(OnMessageContentClickListener onMessageContentClickListener);
  }

  interface Model {

    void addMessage(Message message, @Nullable String chatId);
    void addMessages(@Nullable List<Message> messages, @Nullable String chatId);

    void addMessageItem(MessageItem item);
    void addMessageItems(Collection<MessageItem> items);
    void removeMessageItem(MessageItem item);
    void addOrUpdateMessageItem(int position, MessageItem item);

    int getIndex(MessageItem item);
    @Nullable
    MessageItem getItem(int index);
    @Nullable
    String getLastMessageItemId();

    @Nullable
    WelcomeMessageItem getWelcomeMessageItem();
    void setWelcomeMessage(String message, Long timestamp);

    @Nullable
    SupportBotMessageItem getSupportBotItem();
    void setSupportBotMessage(SupportBotEntry supportBotMessage, Long timestamp);
  }
}
