package com.zoyi.channel.plugin.android.activity.base;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.event.*;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.ActionType;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

/**
 * Created by mika on 2016. 12. 5..
 */
public class BaseActivity extends AppCompatActivity {

  @Nullable
  protected BigBar bigBar;
  @Nullable
  private ProgressDialog progressDialog;
  @Nullable
  private Subscription subscription;

  protected boolean isActivityVisible;
  protected boolean isActivityFocused;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    if (savedInstanceState != null) {
      finish();
      return;
    }

    subscription = RxBus.observable().subscribe(new Action1<Object>() {
          @Override
          public void call(Object o) {
            receiveRxEvent(o);
          }
        });

    ChannelIOManager.increaseActivityRunningCount();
  }

  protected void receiveRxEvent(Object o) {
    if (o instanceof CommandBus) {
      CommandBus commandBus = (CommandBus) o;
      receiveCommand(commandBus.getCommand(), commandBus.getObject());
    }
    if (o instanceof ChannelModelBus) {
      ChannelModelBus channelModelBus = (ChannelModelBus) o;
      receiveData(channelModelBus.getEntity(), channelModelBus.isUpsert());
    }
    if (o instanceof TypingBus) {
      TypingBus typingBus = (TypingBus) o;
      receiveTyping(typingBus.getTyping());
    }
    if (o instanceof LanguageBus) {
      receiveLanguageEvent();
    }
    if (o instanceof StoreBus) {
      StoreBus storeBus = (StoreBus) o;
      if (StoreType.PLUGIN == storeBus.getStoreType()) {
        setThemeColor(ColorSelector.getBackgroundColor(), ColorSelector.getTextColor());
      }
      receiveStoreEvent(storeBus.getStoreType(), storeBus.getUpdateType(), storeBus.getEntity());
    }
  }

  public void finish(boolean animated) {
    finish();
    if (animated) {
      overridePendingTransition(getEnterAnimOfFinish(), getExistAnimOfFinish());
    } else {
      overridePendingTransition(R.anim.ch_plugin_idle, R.anim.ch_plugin_idle);
    }
  }

  @Override
  public void finish() {
    super.finish();
    overridePendingTransition(getEnterAnimOfFinish(), getExistAnimOfFinish());
  }

  @Override
  protected void onStart() {
    super.onStart();
    isActivityVisible = true;
  }

  @Override
  protected void onResume() {
    super.onResume();
    isActivityFocused = true;
  }

  @Override
  protected void onPause() {
    super.onPause();
    isActivityFocused = false;
  }

  @Override
  protected void onStop() {
    isActivityVisible = false;
    super.onStop();
  }

  @Override
  protected void onDestroy() {
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    ChannelIOManager.decreaseActivityRunningCount();
    super.onDestroy();
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    if (resultCode == Const.RESULT_ACTIVITY_FINISH) {
      setResult(resultCode);
      finish();
    }
    super.onActivityResult(requestCode, resultCode, data);
  }

  protected void init(int layoutId) {
    init(layoutId, ColorSelector.getBackgroundColor(), ColorSelector.getTextColor());
  }

  protected void init(int layoutId, @ColorInt int backgroundColor, @ColorInt int textColor) {
    setContentView(layoutId);

    View view = findViewById(R.id.big_bar);
    if (view != null) {
      bigBar = (BigBar) view;
    }

    Plugin plugin = PluginSelector.getPlugin();
    Channel channel = ChannelSelector.getCurrentChannel();

    if (plugin == null || channel == null) {
      finish();
      return;
    }

    setThemeColor(backgroundColor, textColor);
  }



  @Nullable
  protected BigBar getBigBar() {
    return bigBar;
  }

  private void setThemeColor(@ColorInt int backgroundColor, @ColorInt int textColor) {
    setStatusBarColor(backgroundColor);

      if (bigBar != null) {
        bigBar.setTheme(backgroundColor, textColor);
      }
  }

  private void setStatusBarColor(int backgroundColor) {
    try {
      if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
        getWindow().setStatusBarColor(Utils.addBlackMask(backgroundColor));
      }
    } catch (Exception ignored) {}
  }

  public void optionClicked(ActionType actionType) {
    switch (actionType) {
      case BACK:
      case EXIT:
        onBackPressed();
        break;
    }
  }

  public void hideKeyboard(EditText editText) {
    InputMethodManager inputManager
        = (InputMethodManager) this.getSystemService(Context.INPUT_METHOD_SERVICE);

    if (inputManager != null) {
      inputManager.hideSoftInputFromWindow(
          editText.getWindowToken(),
          InputMethodManager.HIDE_NOT_ALWAYS);
    }
  }

  @Nullable
  protected Integer getRequestCode() {
    if (getIntent() != null) {
      return getIntent().getIntExtra(Const.REQUEST_CODE_INTENT_KEY, Integer.MIN_VALUE);
    }
    return null;
  }

  public void showProgress(String message) {
    hideProgress();
    progressDialog = ProgressHelper.show(this, message);
  }

  public void hideProgress() {
    try {
      if (progressDialog != null && progressDialog.isShowing()) {
        progressDialog.dismiss();
      }
    } catch (Exception ignored) {
    }
  }

  public void receiveCommand(Command command, @Nullable Object object) { }

  public void receiveData(Entity entity, boolean upsert) { }

  public void receiveTyping(Typing typing) { }

  public void receiveLanguageEvent() { }

  public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) { }

  // permission

  protected static final int PERMISSION_READ_STORAGE = 1;
  protected static final int PERMISSION_WRITE_STORAGE = 2;
  protected static final int PERMISSION_CAMERA = 3;
  protected static final int PERMISSION_CALL_PHONE = 4;

  @TargetApi(Build.VERSION_CODES.M)
  private String getPermission(int requestCode) {
    switch (requestCode) {
      case PERMISSION_READ_STORAGE:
        return Manifest.permission.READ_EXTERNAL_STORAGE;
      case PERMISSION_WRITE_STORAGE:
        return Manifest.permission.WRITE_EXTERNAL_STORAGE;
      case PERMISSION_CAMERA:
        return Manifest.permission.CAMERA;
      case PERMISSION_CALL_PHONE:
        return Manifest.permission.CALL_PHONE;
    }

    return "";
  }

  protected boolean checkPermission(int... requestCodes) {
    if (requestCodes.length == 0 || Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
      return true;
    }

    String[] requestStr = new String[requestCodes.length];
    int count = 0;

    for (int i = 0; i < requestCodes.length; i++) {
      requestStr[i] = getPermission(requestCodes[i]);
      if (ContextCompat.checkSelfPermission(this, requestStr[i]) == PackageManager.PERMISSION_GRANTED) {
        count++;
      }
    }

    if (count == requestCodes.length) {
      return true;
    }

    ActivityCompat.requestPermissions(this, requestStr, requestCodes[0]);
    return false;
  }

  @Override
  public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] results) {
    for (int result : results) {
      if (result != PackageManager.PERMISSION_GRANTED) {
        permissionRejected(requestCode);
        return;
      }
    }
    permissionAccepted(requestCode);
  }

  protected void permissionAccepted(int requestCode) {
  }

  protected void permissionRejected(int requestCode) {
  }

  @AnimRes
  protected int getEnterAnimOfFinish() {
    return R.anim.ch_plugin_idle;
  }

  @AnimRes
  protected int getExistAnimOfFinish() {
    return R.anim.ch_plugin_slide_out_right;
  }
}
