package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFileMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFormMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnWebMessageClickListener;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.activity.chat.model.FormMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonView;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

/**
 * Created by jerry on 2018. 6. 11..
 */

public class FormMessageHolder extends WebMessageHolder implements View.OnClickListener {

  private Context context;

  private LinearLayout extraMessageContentLayout;
  private FormButtonLayout formButtonLayout;

  private View fileLayout;

  private ImageView fileIconImage;
  private CHTextView fileNameText;
  private CHTextView fileInfoText;

  @Nullable
  private Message message;

  @Nullable
  private OnFormMessageClickListener onFormMessageClickListener;
  @Nullable
  private OnFileMessageClickListener onFileMessageClickListener;
  @Nullable
  private OnWebMessageClickListener onWebMessageClickListener;

  public static FormMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      @Nullable OnFileMessageClickListener onFileMessageClickListener,
      @Nullable OnWebMessageClickListener onWebMessageClickListener,
      @Nullable OnFormMessageClickListener onFormMEssageClickListener) {
    return new FormMessageHolder(
        getItemView(parent, messageType),
        onFileMessageClickListener,
        onWebMessageClickListener,
        onFormMEssageClickListener);
  }

  public FormMessageHolder(
      View itemView,
      @Nullable OnFileMessageClickListener onFileMessageClickListener,
      @Nullable OnWebMessageClickListener onWebMessageClickListener,
      @Nullable OnFormMessageClickListener onFormMessageClickListener) {
    super(itemView, MessageType.FORM_MESSAGE, onWebMessageClickListener);
    this.context = itemView.getContext();
    this.onFileMessageClickListener = onFileMessageClickListener;
    this.onWebMessageClickListener = onWebMessageClickListener;
    this.onFormMessageClickListener = onFormMessageClickListener;

    extraMessageContentLayout = itemView.findViewById(R.id.ch_message_content_extra);
    formButtonLayout = itemView.findViewById(R.id.ch_layout_form_button);

    fileLayout = itemView.findViewById(R.id.ch_message_content_file);
    fileIconImage = itemView.findViewById(R.id.icon_file);
    fileNameText = itemView.findViewById(R.id.text_file_name);
    fileInfoText = itemView.findViewById(R.id.text_file_info);
  }

  public void bind(ChatMessageItem chatItem, boolean isLastMessage, boolean isConnected) {
    super.bind(chatItem, isConnected);
    Message message = chatItem.getMessage();
    this.message = message;

    if (message != null) {
      setFormMessage(message, isLastMessage);

      File file = message.getFile();
      if (file != null && !file.isImage()) {
        setFileMessage(file);
      }
    }
  }

  private void setFormMessage(Message message, boolean isLastMessage) {
    FormMessageItem formMessageItem = new FormMessageItem(message);

    if (!isLastMessage || !ListUtils.hasItems(formMessageItem.getActionInputs())) {
      extraMessageContentLayout.setVisibility(View.GONE);
    } else {
      extraMessageContentLayout.setVisibility(View.VISIBLE);

      formButtonLayout.removeAllViews();
      formButtonLayout.refresh();
      formButtonLayout.setWidth(getButtonLayoutWidth(context));

      for (ActionInput actionInput : formMessageItem.getActionInputs()) {
        addFormButton(formMessageItem.getActionType(), actionInput);
      }
    }
  }

  private void setFileMessage(File file) {
    String fileSize = Utils.getProperBytes(file.getSize());
    String fileType = "";
    String extension = file.getExtension();

    if (!"default".equals(extension) && !TextUtils.isEmpty(extension)) {
      fileType = String.format(" · %s", extension.substring(0, 1).toUpperCase() + extension.substring(1));
    }

    fileLayout.setVisibility(View.VISIBLE);
    fileLayout.setOnClickListener(this);

    fileNameText.setText(file.getFilename());
    fileInfoText.setText(String.format("%s%s", fileSize, fileType));
    fileIconImage.setImageResource(ResUtils.getFileIconResourceId(file));
  }

  private void addFormButton(@Nullable String actionType, ActionInput actionInput) {
    FormButtonView formButtonView = new FormButtonView(context, actionType, actionInput, onFormMessageClickListener);
    formButtonLayout.add(formButtonView);
  }

  // ch_plugin_item_message_form paddingStart, paddingEnd 값과 일치해야함
  private int getButtonLayoutWidth(Context context) {
    int windowWidth = Utils.getWindowSize(context).x;
    int leftPadding = (int) Utils.dpToPx(context, 110f);
    int rightPadding = (int) Utils.dpToPx(context, 10f);

    return windowWidth - (leftPadding + rightPadding);
  }

  // On file clicked
  @Override
  public void onClick(View v) {
    if (onFileMessageClickListener != null && message != null && message.getFile() != null) {
      onFileMessageClickListener.onFileClick(message.getFile());
    }
  }

  @Override
  protected void onImageClick() {
    if (onWebMessageClickListener != null && message != null) {
      if (message.getWebPage() != null) {
        onWebMessageClickListener.onWebDescriptionClick(message.getWebPage().getUrl());
      } else if (message.getFile() != null && message.getFile().isImage()) { // todo : form 메세지 예외처리를 위해 임시로 작성, 추후 개편할 것
        onWebMessageClickListener.onImageClick(message.getFile());
      }
    }
  }
}
