/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnTextMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.BaseMessageHolder;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.TranslationInfo;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.message_format.CustomMovementMethod;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class TextMessageHolder
extends BaseMessageHolder {
    @Nullable
    protected MaskableFrameLayout guestMessageHeadLayout;
    @Nullable
    protected MaskableFrameLayout guestMessageContentLayout;
    @Nullable
    protected CHTextView guestMessageText;
    @Nullable
    protected View guestMessageTopView;
    @Nullable
    protected View guestMessageContentView;
    @Nullable
    protected View managerMessageHeadTop;
    @Nullable
    protected View managerMessageContextTop;
    @Nullable
    protected CHTextView managerMessageText;
    @Nullable
    private TextView giantEmojiText;
    @Nullable
    private View hostMessageTranslationLayout;
    @Nullable
    private LinearLayout translationButtonLayout;
    @Nullable
    private CHTextView translationButton;
    @Nullable
    private ImageView translationButtonArrow;
    @Nullable
    private CircularProgressView translationProgressView;
    @Nullable
    private Message message;
    @Nullable
    private OnTextMessageClickListener listener;

    public static TextMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnTextMessageClickListener listener) {
        return new TextMessageHolder(TextMessageHolder.getItemView(parent, messageType), messageType, listener);
    }

    public TextMessageHolder(View itemView, MessageType messageType, @Nullable OnTextMessageClickListener listener) {
        super(itemView, messageType);
        this.listener = listener;
        switch (messageType) {
            case GUEST_TEXT_MESSAGE: 
            case GUEST_IMAGE_MESSAGE: 
            case GUEST_FILE_MESSAGE: 
            case GUEST_WEB_MESSAGE: {
                this.guestMessageHeadLayout = (MaskableFrameLayout)itemView.findViewById(R.id.ch_layout_guest_message_head);
                this.guestMessageContentLayout = (MaskableFrameLayout)itemView.findViewById(R.id.ch_layout_guest_message_content);
                this.guestMessageText = (CHTextView)itemView.findViewById(R.id.ch_text_guest_message);
                this.guestMessageTopView = itemView.findViewById(R.id.ch_view_guest_message_head_top);
                this.guestMessageContentView = itemView.findViewById(R.id.ch_view_guest_message_content_top);
                this.giantEmojiText = (TextView)itemView.findViewById(R.id.ch_message_content_giant_emoji);
                break;
            }
            default: {
                this.managerMessageHeadTop = itemView.findViewById(R.id.ch_view_manager_message_head_top);
                this.managerMessageContextTop = itemView.findViewById(R.id.ch_view_manager_message_context_top);
                this.managerMessageText = (CHTextView)itemView.findViewById(R.id.ch_text_manager_message);
                this.giantEmojiText = (TextView)itemView.findViewById(R.id.ch_message_content_giant_emoji);
                this.hostMessageTranslationLayout = itemView.findViewById(R.id.ch_message_content_translate);
                this.translationButtonLayout = (LinearLayout)itemView.findViewById(R.id.ch_layout_translate_button);
                this.translationButton = (CHTextView)itemView.findViewById(R.id.ch_text_host_message_translate);
                this.translationButtonArrow = (ImageView)itemView.findViewById(R.id.ch_img_host_message_translate_arrow);
                this.translationProgressView = (CircularProgressView)itemView.findViewById(R.id.ch_progress_host_message_translate);
                this.setTranslationButtonClickListener();
            }
        }
    }

    public void bind(ChatMessageItem item, boolean isConnectedMessage) {
        super.bind(item.getMessage(), item.getType(), isConnectedMessage);
        this.message = item.getMessage();
        switch (item.getType()) {
            case GUEST_TEXT_MESSAGE: 
            case GUEST_IMAGE_MESSAGE: 
            case GUEST_FILE_MESSAGE: 
            case GUEST_WEB_MESSAGE: {
                this.setGuestMessageText(item, isConnectedMessage);
                break;
            }
            default: {
                this.setManagerMessageText(item, isConnectedMessage);
            }
        }
    }

    private void setGuestMessageText(ChatMessageItem item, boolean isConnectedMessage) {
        if (item.getMessage() == null) {
            return;
        }
        if (item.getMessage().hasOnlyEmoji()) {
            this.setGiantEmoji(item.getMessage());
        } else if (item.getMessage().getMessage() != null && this.guestMessageTextLayout != null && this.guestMessageHeadLayout != null && this.guestMessageContentLayout != null && this.guestMessageText != null && this.guestMessageTopView != null && this.guestMessageContentView != null) {
            this.guestMessageTextLayout.setVisibility(0);
            this.guestMessageHeadLayout.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
            this.guestMessageContentLayout.setVisibility(UIUtils.getVisible(isConnectedMessage, true));
            this.guestMessageTopView.setBackgroundColor(ColorSelector.getBackgroundColor());
            this.guestMessageContentView.setBackgroundColor(ColorSelector.getBackgroundColor());
            this.guestMessageText.setBackgroundColor(ColorSelector.getBackgroundColor());
            this.guestMessageText.setMovementMethod((MovementMethod)CustomMovementMethod.getInstance());
            this.guestMessageText.setLinkTextColor(ColorSelector.getTextColor());
            this.guestMessageText.setTextColor(ColorSelector.getTextColor());
            this.guestMessageText.setText((CharSequence)this.message.getFormattedSpanMessage());
        }
    }

    private void setManagerMessageText(ChatMessageItem item, boolean isConnectedMessage) {
        if (item.getMessage() == null) {
            return;
        }
        if (item.getMessage().hasOnlyEmoji()) {
            this.setGiantEmoji(item.getMessage());
        } else if (item.getMessage().getMessage() != null && this.managerMessageTextLayout != null && this.managerMessageHeadTop != null && this.managerMessageContextTop != null && this.managerMessageText != null) {
            this.managerMessageTextLayout.setVisibility(0);
            this.managerMessageHeadTop.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
            this.managerMessageContextTop.setVisibility(UIUtils.getVisible(isConnectedMessage, true));
            this.managerMessageText.setMovementMethod((MovementMethod)CustomMovementMethod.getInstance());
            if (this.message != null) {
                this.managerMessageText.setText((CharSequence)this.message.getFormattedSpanMessage());
            }
            if (item.shouldTranslateMessage(this.message)) {
                this.hostMessageTranslationLayout.setVisibility(0);
                this.setTranslationLayoutState(this.message);
            }
        }
    }

    private void setGiantEmoji(Message message) {
        if (this.giantEmojiText != null) {
            this.giantEmojiText.setVisibility(0);
            this.giantEmojiText.setText((CharSequence)message.getFormattedSpanMessage());
        }
    }

    private void setTranslationLayoutState(Message message) {
        SpannableStringBuilder messageContent = message.getFormattedSpanMessage();
        TranslationInfo translationInfo = TranslationSelector.get(TranslationInfo.createId(message.getId(), PrefSupervisor.getPluginLanguage(this.context)));
        if (translationInfo == null || TranslationState.ORIGIN.equals((Object)translationInfo.getState())) {
            this.setTranslateLayoutWithoutProgress("show_translate", false);
        } else if (TranslationState.TRANSLATED.equals((Object)translationInfo.getState())) {
            messageContent = translationInfo.getTranslatedMessage();
            this.setTranslateLayoutWithoutProgress("undo_translate", true);
        } else if (TranslationState.PROGRESS.equals((Object)translationInfo.getState())) {
            this.translationButtonLayout.setVisibility(4);
            this.translationProgressView.setVisibility(0);
        }
        if (this.managerMessageText != null) {
            this.managerMessageText.setText((CharSequence)messageContent);
        }
    }

    private void setTranslateLayoutWithoutProgress(String textKey, boolean isTranslated) {
        this.translationButtonLayout.setVisibility(0);
        this.translationProgressView.setVisibility(8);
        this.translationButton.setTextByKey(textKey);
        this.translationButtonArrow.setVisibility(UIUtils.getVisible(isTranslated, true));
    }

    private void setTranslationButtonClickListener() {
        this.translationButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TranslationInfo translationInfo;
                if (TextMessageHolder.this.message != null && TextMessageHolder.this.listener != null && ((translationInfo = TranslationSelector.get(TranslationInfo.createId(TextMessageHolder.this.message.getId(), PrefSupervisor.getPluginLanguage(TextMessageHolder.this.context)))) == null || translationInfo.getState() != TranslationState.PROGRESS)) {
                    TextMessageHolder.this.listener.onTranslationMessageClick(TextMessageHolder.this.message);
                }
            }
        });
    }
}

