/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.base;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.util.SortedListAdapterCallback;
import com.zoyi.channel.plugin.android.activity.base.SortableItem;
import com.zoyi.channel.plugin.android.util.CompareUtils;

public class SortedListCallback<E extends SortableItem>
extends SortedListAdapterCallback<E> {
    private RecyclerView.Adapter adapter;
    private boolean desc;

    public SortedListCallback(RecyclerView.Adapter adapter, boolean desc) {
        super(adapter);
        this.desc = desc;
        this.adapter = adapter;
    }

    public int compare(SortableItem o1, SortableItem o2) {
        int comp = CompareUtils.compare(o2.getPrimaryKey(), o1.getPrimaryKey());
        if (comp == 0) {
            return CompareUtils.compare(o2.getSecondaryKey(), o1.getSecondaryKey()) * (this.desc ? 1 : -1);
        }
        return comp * (this.desc ? 1 : -1);
    }

    public boolean areContentsTheSame(SortableItem oldItem, SortableItem newItem) {
        return false;
    }

    public void onInserted(int position, int count) {
        try {
            this.adapter.notifyItemRangeInserted(position, count);
            this.adapter.notifyItemChanged(position - 1);
            this.adapter.notifyItemChanged(position + count);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onRemoved(int position, int count) {
        try {
            this.adapter.notifyItemRangeRemoved(position, count);
            this.adapter.notifyItemChanged(Math.max(position - 1, 0), (Object)2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean areItemsTheSame(SortableItem item1, SortableItem item2) {
        return CompareUtils.compare(item1.getPrimaryKey(), item2.getPrimaryKey()) == 0 && CompareUtils.compare(item1.getSecondaryKey(), item2.getSecondaryKey()) == 0;
    }
}

