/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.persistentcookiejar.cache;

import com.zoyi.channel.plugin.android.util.persistentcookiejar.cache.CookieCache;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.cache.IdentifiableCookie;
import com.zoyi.okhttp3.Cookie;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetCookieCache
implements CookieCache {
    private Set<IdentifiableCookie> cookies = new HashSet<IdentifiableCookie>();

    @Override
    public void addAll(Collection<Cookie> newCookies) {
        for (IdentifiableCookie cookie : IdentifiableCookie.decorateAll(newCookies)) {
            this.cookies.remove(cookie);
            this.cookies.add(cookie);
        }
    }

    @Override
    public void clear() {
        this.cookies.clear();
    }

    @Override
    public Iterator<Cookie> iterator() {
        return new SetCookieCacheIterator();
    }

    private class SetCookieCacheIterator
    implements Iterator<Cookie> {
        private Iterator<IdentifiableCookie> iterator;

        public SetCookieCacheIterator() {
            this.iterator = SetCookieCache.this.cookies.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Cookie next() {
            return this.iterator.next().getCookie();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

