package com.zoyi.channel.plugin.android.store;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.StoreBus;
import com.zoyi.channel.plugin.android.model.entity.Entity;

import java.util.*;

/**
 * Created by mika on 2018. 6. 18..
 */

public abstract class CollectionStore<E extends Entity> extends Store {

  protected Map<String, E> map = new HashMap<>();

  protected boolean canUpdate(E oldbie, E newbie) {
    return true;
  }

  @Nullable
  public synchronized E get(@Nullable String id) {
    if (id == null) {
      return null;
    }
    return map.get(id);
  }

  public synchronized List<E> get() {
    return new ArrayList<>(map.values());
  }

  public synchronized void set(Collection<E> list) {
    map.clear();
    add(list);
  }

  private boolean upsert(E e) {
    if (e != null) {
      if (map.get(e.getId()) == null || canUpdate(map.get(e.getId()), e)) {
        map.put(e.getId(), e);
        return true;
      }
    }
    return false;
  }

  public synchronized void add(E e) {
    if (upsert(e)) {
      updated(e);
    }
  }

  public synchronized void add(@Nullable Collection<E> list) {
    if (list != null) {
      for (E e : list) {
        upsert(e);
      }
    }
    RxBus.post(new StoreBus<>(getStoreType()));
  }

  public synchronized void remove(@Nullable E e) {
    if (e != null && e.getId() != null) {
      E item = map.remove(e.getId());

      if (item != null) {
        removed(e);
      }
    }
  }

  public synchronized int size() {
    return map.size();
  }

  protected void updated(E e) {
    RxBus.post(new StoreBus<>(getStoreType(), UpdateType.UPDATE, e));
  }

  protected void removed(E e) {
    RxBus.post(new StoreBus<>(getStoreType(), UpdateType.DELETE, e));
  }
}
