package com.zoyi.channel.plugin.android.model.rest;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Guest;

import java.util.Map;

/**
 * Created by mika on 2017. 1. 16..
 */
public class User implements Guest {
  private String id;
  private String name;
  private String mobileNumber;
  private String avatarUrl;
  private Object meta;
  private Boolean named;
  private Long updatedAt;
  private Map<String, Object> profile;
  private int alert;

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  @Override
  public String getMobileNumber() {
    return mobileNumber;
  }

  public final static String CLASSNAME = "User";

  @Override
  public boolean isNamed() {
    return named == null ? false : named;
  }

  @Override
  public int getAlert() {
    return alert;
  }

  @Override
  public Map<String, Object> getProfile() {
    return profile;
  }

  @Override
  public Object getProfileValue(String key) {
    if (profile != null) {
      return profile.get(key);
    } else {
      return null;
    }
  }

  @Override
  public String getPersonType() {
    return Const.USER;
  }

  @Override
  public String getPersonId() {
    return id;
  }
}
