/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.text.TextUtils;

public class CompareUtils {
    public static boolean isSame(String s1, String s2) {
        return CompareUtils.compare(s1, s2) == 0;
    }

    public static int compare(String s1, String s2) {
        if (TextUtils.isEmpty((CharSequence)s1) && TextUtils.isEmpty((CharSequence)s2)) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)s1)) {
            return 1;
        }
        if (TextUtils.isEmpty((CharSequence)s2)) {
            return -1;
        }
        int end = Math.min(s1.length(), s2.length());
        for (int i = 0; i < end; ++i) {
            int i2;
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) continue;
            int i1 = CompareUtils.asciiCase(c1);
            int result = i1 - (i2 = CompareUtils.asciiCase(c2));
            if (result != 0) {
                return result;
            }
            result = (c1 = CompareUtils.foldCase(c1)) - (c2 = CompareUtils.foldCase(c2));
            if (result == 0) continue;
            return result;
        }
        return s1.length() - s2.length();
    }

    public static int compare(int lhs, int rhs) {
        return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
    }

    public static int compare(Long lhs, Long rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return 1;
        }
        if (rhs == null) {
            return -1;
        }
        return lhs < rhs ? -1 : (lhs.equals(rhs) ? 0 : 1);
    }

    public static String max(String s1, String s2) {
        if (CompareUtils.compare(s1, s2) < 0) {
            return s2;
        }
        return s1;
    }

    public static String min(String s1, String s2) {
        if (CompareUtils.compare(s1, s2) < 0) {
            return s1;
        }
        return s2;
    }

    @SafeVarargs
    public static <E extends Comparable> boolean exists(E target, E ... values) {
        for (E ee : values) {
            if (!(ee == null ? target == null : ee.equals(target))) continue;
            return true;
        }
        return false;
    }

    private static int asciiCase(char ch) {
        return ch < '\u0080' ? 1 : 0;
    }

    private static char foldCase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }
}

