/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import com.splunk.mint.BreadcrumbsLimited;
import com.splunk.mint.EnumActionType;
import com.splunk.mint.ExcludedUrls;
import com.splunk.mint.ExtraData;
import com.splunk.mint.Logger;
import com.splunk.mint.Mint;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.MintUrls;
import com.splunk.mint.RemoteSettings;
import com.splunk.mint.RemoteSettingsData;
import com.splunk.mint.StartedTransactions;
import com.splunk.mint.UidManager;
import com.splunk.mint.Utils;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONObject;

public class Properties {
    public static final String SDK_VERSION = "5.2.1";
    protected static final String API_VERSION = "1";
    protected static final String SDK_PLATFORM = "Android";
    public static final String REST_VERSION = "1.0";
    private static boolean initialized = false;
    private static MintUrls mintUrls;
    private static final String[] defaultExcludedUrls;
    public static final ExcludedUrls excludedUrls;
    static final String REMOTEIP_PLACEHOLDER = "{%#@@#%}";
    static String CONNECTION;
    static String STATE;
    static String FILES_PATH;
    static String APP_VERSIONNAME;
    static String APP_VERSIONCODE;
    static String APP_PACKAGE;
    static final String TAG = "Mint";
    static String ISFSENCRYPTED;
    static int BATTERY_LEVEL;
    static String OS_VERSION;
    static String PHONE_MODEL;
    static String PHONE_BRAND;
    static String API_KEY;
    static boolean HAS_ROOT;
    static String LOCALE;
    static String CARRIER;
    static String SCREEN_ORIENTATION;
    static String UID;
    static BreadcrumbsLimited breadcrumbs;
    static ExtraData extraData;
    static boolean SEND_LOG;
    static String LOG_FILTER;
    static int LOG_LINES;
    static long TIMESTAMP;
    static boolean proxyEnabled;
    static byte IS_GPS_ON;
    static boolean sendOnlyWiFi;
    static String userIdentifier;
    static String applicationEnvironment;
    static volatile StartedTransactions startedTransactions;
    public static boolean isKitKat;
    public static boolean flushOnlyOverWiFi;
    public static boolean USER_OPTEDOUT;
    public static String lastView;
    public static long lastViewTime;
    public static boolean hecEnabled;
    protected static String hecToken;
    public static Location location;
    static final long backgroundSessionTimeout = 300L;

    public static boolean isPluginInitialized() {
        if (!initialized) {
            Logger.logWarning("Mint SDK is not initialized!");
        }
        return initialized;
    }

    public static void uninitialize() {
        initialized = false;
    }

    protected static void initialize(Context context, String url, String token, String apiKey) {
        block13: {
            block12: {
                if (!initialized) {
                    startedTransactions = null;
                    UID = UidManager.getUid(context);
                    mintUrls = new MintUrls(url, token, apiKey);
                    HAS_ROOT = Utils.checkForRoot();
                    RemoteSettingsData remoteSettings = RemoteSettings.loadRemoteSettings(context);
                    if (remoteSettings != null) {
                        RemoteSettingsProps.logLevel = remoteSettings.logLevel;
                        RemoteSettingsProps.eventLevel = remoteSettings.eventLevel;
                        RemoteSettingsProps.netMonitoringEnabled = remoteSettings.netMonitoring;
                        RemoteSettingsProps.sessionTime = remoteSettings.sessionTime;
                        RemoteSettingsProps.hashCode = remoteSettings.hashCode;
                        try {
                            RemoteSettingsProps.devSettings = new JSONObject(remoteSettings.devSettings);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        FILES_PATH = context.getFilesDir().getAbsolutePath();
                    }
                    catch (Exception e) {
                        if (!Mint.DEBUG) break block12;
                        e.printStackTrace();
                    }
                }
            }
            try {
                PackageManager pm = context.getPackageManager();
                PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
                APP_VERSIONNAME = pi.versionName;
                APP_VERSIONCODE = String.valueOf(pi.versionCode);
                APP_PACKAGE = pi.packageName;
            }
            catch (Exception e) {
                Logger.logError("Error collecting information about the package!");
                if (!Mint.DEBUG) break block13;
                e.printStackTrace();
            }
        }
        PHONE_MODEL = Build.MODEL;
        PHONE_BRAND = Build.MANUFACTURER;
        OS_VERSION = Build.VERSION.RELEASE;
        lastView = "NA";
        ISFSENCRYPTED = Utils.isFSEncrypted(context);
        BATTERY_LEVEL = Utils.getBatteryLevel(context);
        isKitKat = Utils.isKitKat();
        if (breadcrumbs == null) {
            breadcrumbs = new BreadcrumbsLimited();
        }
        if (extraData == null) {
            extraData = new ExtraData();
        }
        if (startedTransactions == null) {
            startedTransactions = new StartedTransactions();
        }
        IS_GPS_ON = Utils.isGPSOn(context);
        LOCALE = Locale.getDefault().getCountry();
        if (LOCALE == null || LOCALE.length() == 0) {
            LOCALE = "NA";
        }
        CARRIER = Utils.getCarrier(context);
        SCREEN_ORIENTATION = Utils.getScreenOrientation(context);
        HashMap<String, String> conInfo = Utils.getConnectionInfo(context);
        CONNECTION = conInfo.get("connection");
        STATE = conInfo.get("state");
        initialized = true;
    }

    protected static final String getSeparator(byte actionName) {
        return Properties.getSeparator(actionName, Utils.getTime());
    }

    protected static final String getSeparator(byte actionName, String timestamp) {
        return "{^1^" + EnumActionType.getStringFromType(actionName) + "^" + timestamp + "}";
    }

    static {
        defaultExcludedUrls = new String[]{"splkmobile.com"};
        excludedUrls = new ExcludedUrls(defaultExcludedUrls);
        CONNECTION = "NA";
        STATE = "NA";
        FILES_PATH = null;
        APP_VERSIONNAME = "NA";
        APP_VERSIONCODE = "NA";
        APP_PACKAGE = "NA";
        ISFSENCRYPTED = "NA";
        BATTERY_LEVEL = 50;
        OS_VERSION = "NA";
        PHONE_MODEL = "NA";
        PHONE_BRAND = null;
        API_KEY = "NA";
        HAS_ROOT = false;
        LOCALE = "NA";
        CARRIER = "NA";
        SCREEN_ORIENTATION = "NA";
        UID = "";
        breadcrumbs = new BreadcrumbsLimited();
        extraData = new ExtraData();
        SEND_LOG = false;
        LOG_FILTER = "";
        LOG_LINES = 500;
        TIMESTAMP = 0L;
        proxyEnabled = false;
        IS_GPS_ON = (byte)2;
        sendOnlyWiFi = false;
        userIdentifier = "NA";
        applicationEnvironment = "Release";
        startedTransactions = new StartedTransactions();
        isKitKat = false;
        flushOnlyOverWiFi = false;
        USER_OPTEDOUT = false;
        lastView = "NA";
        lastViewTime = 0L;
        hecEnabled = false;
    }

    public static class RemoteSettingsProps {
        static Integer logLevel = Utils.convertLoggingLevelToInt(MintLogLevel.Verbose);
        static Integer eventLevel = Utils.convertLoggingLevelToInt(MintLogLevel.Verbose);
        static Boolean netMonitoringEnabled = true;
        static Integer sessionTime = 60;
        static JSONObject devSettings = new JSONObject();
        static String hashCode = "none";

        public static String toReadableFormat() {
            return "loglevel: " + String.valueOf(logLevel) + " eventLevel: " + String.valueOf(eventLevel) + " netMonitoring: " + String.valueOf(netMonitoringEnabled) + " sessionTime: " + String.valueOf(sessionTime) + " devSettings: " + devSettings.toString() + " hashCode: " + hashCode;
        }
    }
}

