package com.zoyi.channel.plugin.android.util.message_format.message;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.RelativeSizeSpan;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by mika on 2018. 7. 2..
 */

public class GiantEmojiMessage implements MessagePattern {

  private Pattern pattern = Pattern.compile("[^\\uD83C-\\uDBFF\\uDC00-\\uDFFF]+");

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {
    Matcher matcher = pattern.matcher(span);

    if (!matcher.find()) {
      int length = span.toString().length();

      span.setSpan(
          new RelativeSizeSpan(2.32f),
          0,
          length,
          Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
    }

    return span;
  }
}
