/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFormMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageReviewListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ClosedUserChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.DateItem;
import com.zoyi.channel.plugin.android.activity.chat.model.LogMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ResolveMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.TypingItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.CloseMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.DateDividerHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.FileMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.FormMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ImageMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.LogMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.NewMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ProfileBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ResolveMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SendingMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TextMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TypingHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.WebMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.WelcomeMessageHolder;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ListUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChatAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ChatAdapterContract.Model,
ChatAdapterContract.View {
    @Nullable
    private UserChat userChat;
    private SortedList<MessageItem> items;
    @Nullable
    private OnMessageClickListener onMessageClickListener;
    @Nullable
    private OnSendingMessageClickListener onSendingMessageClickListener;
    @Nullable
    private OnMessageReviewListener onMessageReviewListener;
    @Nullable
    private OnProfileUpdateListener onProfileUpdateListener;
    @Nullable
    private OnFormMessageClickListener onFormMessageClickListener;
    @Nullable
    private ResolveMessageItem resolveMessageItem = null;
    @Nullable
    private ClosedUserChatMessageItem closedUserChatMessageItem = null;
    @Nullable
    private WelcomeMessageItem welcomeMessageItem = null;
    private boolean isNewChat;
    private boolean hasChatEditTextFocus = false;

    public ChatAdapter(boolean isNewChat) {
        this.isNewChat = isNewChat;
        this.items = new SortedList(MessageItem.class, new SortedListCallback(this, false));
        this.items.add((Object)new TypingItem());
    }

    @Override
    public void setOnMessageClickListener(OnMessageClickListener onMessageClickListener) {
        this.onMessageClickListener = onMessageClickListener;
    }

    @Override
    public void setOnSendingMessageClickListener(OnSendingMessageClickListener onSendingMessageClickListener) {
        this.onSendingMessageClickListener = onSendingMessageClickListener;
    }

    @Override
    public void setOnMessageReviewListener(OnMessageReviewListener onMessageReviewListener) {
        this.onMessageReviewListener = onMessageReviewListener;
    }

    @Override
    public void setOnProfileUpdateListener(OnProfileUpdateListener onProfileUpdateListener) {
        this.onProfileUpdateListener = onProfileUpdateListener;
    }

    @Override
    public void setOnFormMessageClickListener(OnFormMessageClickListener onFormMessageClickListener) {
        this.onFormMessageClickListener = onFormMessageClickListener;
    }

    @Override
    public void setUserChat(@Nullable UserChat userChat) {
        this.userChat = userChat;
    }

    @Override
    public void addMessage(Message message, @Nullable String chatId) {
        this.addMessages(Collections.singletonList(message), chatId);
    }

    @Override
    public void addMessages(@Nullable List<Message> messages, @Nullable String chatId) {
        if (!ListUtils.hasItems(messages) || TextUtils.isEmpty((CharSequence)chatId)) {
            return;
        }
        this.items.beginBatchedUpdates();
        for (Message message : messages) {
            SendingMessageItem item;
            if (message == null || !CompareUtils.isSame(chatId, message.getChatId())) continue;
            if (this.isNewChat && message.getBotOption() != null && message.getBotOption().isWelcome() && this.welcomeMessageItem != null) {
                this.items.remove((Object)this.welcomeMessageItem);
                this.items.add((Object)new DateItem(message.getCreatedAt()));
                this.items.add((Object)new ChatMessageItem(message));
                this.welcomeMessageItem = null;
                continue;
            }
            if (message.getLog() != null) {
                this.items.add((Object)new LogMessageItem(message));
                continue;
            }
            this.items.add((Object)new ChatMessageItem(message));
            this.items.add((Object)new DateItem(message.getCreatedAt()));
            if (message.getProfileBot() != null) {
                this.items.add((Object)new ProfileBotMessageItem(message));
                continue;
            }
            if (!CompareUtils.exists((Comparable)((Object)message.getPersonType()), (Comparable[])new String[]{"User", "Veil"}) || (item = SendingMessageItem.create(message.getRequestId())) == null) continue;
            this.items.remove((Object)item);
        }
        if (this.userChat != null) {
            if (this.userChat.isStateResolved()) {
                if (this.resolveMessageItem == null) {
                    this.resolveMessageItem = new ResolveMessageItem(0x7FFFFFFFFFFFFFFEL);
                    this.items.add((Object)this.resolveMessageItem);
                }
            } else if (this.userChat.isStateClosed()) {
                this.removeMessageItem(this.resolveMessageItem);
                if (this.closedUserChatMessageItem == null) {
                    this.closedUserChatMessageItem = new ClosedUserChatMessageItem(this.userChat, 0x7FFFFFFFFFFFFFFEL);
                    this.items.add((Object)this.closedUserChatMessageItem);
                }
            }
        }
        this.items.endBatchedUpdates();
    }

    @Override
    public void addMessageItem(MessageItem item) {
        this.items.add((Object)item);
    }

    @Override
    public void addMessageItems(Collection<MessageItem> items) {
        this.items.addAll(items);
    }

    @Override
    public void removeMessageItem(@Nullable MessageItem item) {
        if (item == null) {
            return;
        }
        this.items.remove((Object)item);
    }

    @Override
    public void addOrUpdateMessageItem(int position, MessageItem item) {
        if (position >= 0) {
            this.items.updateItemAt(position, (Object)item);
        } else {
            this.addMessageItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageItem(UserChat userChat) {
        if (userChat == null) {
            return;
        }
        Class<ChatAdapter> clazz = ChatAdapter.class;
        synchronized (ChatAdapter.class) {
            if (userChat.isStateResolved()) {
                if (this.resolveMessageItem == null) {
                    this.resolveMessageItem = new ResolveMessageItem(Long.MAX_VALUE);
                    this.addMessageItem(this.resolveMessageItem);
                }
            } else if (userChat.isStateClosed()) {
                this.removeMessageItem(this.resolveMessageItem);
                if (this.closedUserChatMessageItem == null) {
                    this.closedUserChatMessageItem = new ClosedUserChatMessageItem(userChat, Long.MAX_VALUE);
                    this.addMessageItem(this.closedUserChatMessageItem);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Nullable
    public MessageItem getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return (MessageItem)this.items.get(index);
    }

    @Nullable
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater i = LayoutInflater.from((Context)parent.getContext());
        MessageType type = MessageType.fromId(viewType);
        switch (type) {
            case SENDING: {
                return SendingMessageHolder.newInstance(parent, type, this.onSendingMessageClickListener);
            }
            case DATE: {
                return new DateDividerHolder(i.inflate(R.layout.ch_plugin_item_message_date, parent, false));
            }
            case NEW_MESSAGE_DIVIDER: {
                return new NewMessageHolder(i.inflate(R.layout.ch_plugin_item_message_unread_divider, parent, false));
            }
            case RESOLVE: {
                return new ResolveMessageHolder(i.inflate(R.layout.ch_plugin_item_message_resolve, parent, false), this.onMessageReviewListener);
            }
            case CLOSE: {
                return new CloseMessageHolder(i.inflate(R.layout.ch_plugin_item_message_close, parent, false));
            }
            case LOG: {
                return new LogMessageHolder(i.inflate(R.layout.ch_plugin_item_message_log, parent, false));
            }
            case TYPING: {
                return TypingHolder.newInstance(parent);
            }
            case GUEST_TEXT_MESSAGE: 
            case MANAGER_TEXT_MESSAGE: 
            case BOT_TEXT_MESSAGE: {
                return TextMessageHolder.newInstance(parent, type);
            }
            case GUEST_IMAGE_MESSAGE: 
            case MANAGER_IMAGE_MESSAGE: 
            case BOT_IMAGE_MESSAGE: {
                return ImageMessageHolder.newInstance(parent, type, this.onMessageClickListener);
            }
            case GUEST_FILE_MESSAGE: 
            case MANAGER_FILE_MESSAGE: 
            case BOT_FILE_MESSAGE: {
                return FileMessageHolder.newInstance(parent, type, this.onMessageClickListener);
            }
            case GUEST_WEB_MESSAGE: 
            case MANAGER_WEB_MESSAGE: 
            case BOT_WEB_MESSAGE: {
                return WebMessageHolder.newInstance(parent, type, this.onMessageClickListener);
            }
            case PROFILE_BOT_MESSAGE: {
                return ProfileBotMessageHolder.newInstance(parent, this.onProfileUpdateListener);
            }
            case FORM_MESSAGE: {
                return FormMessageHolder.newInstance(parent, type, this.onFormMessageClickListener);
            }
            case WELCOME_MESSAGE: {
                return WelcomeMessageHolder.newInstance(parent);
            }
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        MessageItem item = (MessageItem)this.items.get(position);
        MessageType type = item.getType();
        switch (item.getType()) {
            case SENDING: {
                SendingMessageItem sendingMessageItem = (SendingMessageItem)item;
                SendingMessageHolder sendingHolder = (SendingMessageHolder)holder;
                sendingHolder.bind(sendingMessageItem, sendingMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case DATE: {
                DateDividerHolder dateDividerHolder = (DateDividerHolder)holder;
                dateDividerHolder.set((DateItem)item);
                break;
            }
            case CLOSE: {
                CloseMessageHolder closeMessageHolder = (CloseMessageHolder)holder;
                closeMessageHolder.bind((ClosedUserChatMessageItem)item);
                break;
            }
            case LOG: {
                LogMessageHolder logMessageHolder = (LogMessageHolder)holder;
                logMessageHolder.bind((LogMessageItem)item);
                break;
            }
            case TYPING: {
                ((TypingHolder)holder).bind((TypingItem)item);
                break;
            }
            case GUEST_TEXT_MESSAGE: 
            case MANAGER_TEXT_MESSAGE: 
            case BOT_TEXT_MESSAGE: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                TextMessageHolder textMessageHolder = (TextMessageHolder)holder;
                textMessageHolder.bind(chatMessageItem, chatMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case GUEST_FILE_MESSAGE: 
            case MANAGER_FILE_MESSAGE: 
            case BOT_FILE_MESSAGE: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                FileMessageHolder fileMessageHolder = (FileMessageHolder)holder;
                fileMessageHolder.bind(chatMessageItem, chatMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case GUEST_IMAGE_MESSAGE: 
            case MANAGER_IMAGE_MESSAGE: 
            case BOT_IMAGE_MESSAGE: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                ImageMessageHolder imageMessageHolder = (ImageMessageHolder)holder;
                imageMessageHolder.bind(chatMessageItem, chatMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case GUEST_WEB_MESSAGE: 
            case MANAGER_WEB_MESSAGE: 
            case BOT_WEB_MESSAGE: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                WebMessageHolder webMessageHolder = (WebMessageHolder)holder;
                webMessageHolder.bind(chatMessageItem, chatMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case PROFILE_BOT_MESSAGE: {
                ProfileBotMessageItem profileItem = (ProfileBotMessageItem)item;
                ProfileBotMessageHolder profileBotMessageHolder = (ProfileBotMessageHolder)holder;
                profileBotMessageHolder.bind(profileItem, this.getChatEditTextFocus());
                break;
            }
            case FORM_MESSAGE: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                FormMessageHolder formMessageHolder = (FormMessageHolder)holder;
                formMessageHolder.bind(chatMessageItem, position == this.getItemCount() - 2, chatMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case WELCOME_MESSAGE: {
                WelcomeMessageItem welcomeMessageItem = (WelcomeMessageItem)item;
                WelcomeMessageHolder welcomeMessageHolder = (WelcomeMessageHolder)holder;
                welcomeMessageHolder.bind(welcomeMessageItem);
            }
        }
    }

    public int getItemViewType(int position) {
        return ((MessageItem)this.items.get(position)).getType().toInt();
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public int getIndex(MessageItem item) {
        return this.items.indexOf((Object)item);
    }

    @Override
    public void setImageFilesToStorage() {
        PhotoAlbumStorage instance = PhotoAlbumStorage.getInstance();
        for (int i = 0; i < this.items.size(); ++i) {
            ChatMessageItem chatMessageItem;
            Message message;
            File file;
            MessageItem messageItem = (MessageItem)this.items.get(i);
            if (messageItem.getType() != MessageType.MANAGER_IMAGE_MESSAGE && messageItem.getType() != MessageType.GUEST_IMAGE_MESSAGE && messageItem.getType() != MessageType.BOT_IMAGE_MESSAGE || (file = (message = (chatMessageItem = (ChatMessageItem)messageItem).getMessage()).getFile()) == null || !file.isImage() || TextUtils.isEmpty((CharSequence)file.getUrl()) || TextUtils.isEmpty((CharSequence)file.getFilename()) || file.getSize() <= 0L) continue;
            instance.addImageFile(file);
        }
    }

    @Override
    @Nullable
    public String getLastMessageItemId() {
        if (this.items.size() > 1) {
            MessageItem messageItem = (MessageItem)this.items.get(this.items.size() - 2);
            return String.format("%s:%s", messageItem.getPrimaryKey(), messageItem.getSecondaryKey());
        }
        return null;
    }

    @Override
    @Nullable
    public WelcomeMessageItem getWelcomeMessage() {
        return this.welcomeMessageItem;
    }

    @Override
    public void setWelcomeMessage(String message, Long timestamp) {
        if (this.welcomeMessageItem != null) {
            this.items.remove((Object)this.welcomeMessageItem);
        }
        this.welcomeMessageItem = new WelcomeMessageItem(message, timestamp);
        this.addMessageItem(this.welcomeMessageItem);
    }

    public void setChatEditTextFocus(boolean hasFocus) {
        this.hasChatEditTextFocus = hasFocus;
    }

    private boolean getChatEditTextFocus() {
        return this.hasChatEditTextFocus;
    }

    @Nullable
    public MessageItem get(int position) {
        if (position < 0 || position >= this.items.size()) {
            return null;
        }
        return (MessageItem)this.items.get(position);
    }
}

