package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

/**
 * Created by jerry on 2018. 3. 28..
 */

public class FileMessageHolder extends BaseMessageHolder implements View.OnClickListener {

  protected View fileLayout;

  protected ImageView fileIconImage;
  protected CHTextView fileNameText;
  protected CHTextView fileInfoText;

  @Nullable
  private Message message;
  @Nullable
  private OnMessageClickListener listener;

  public static FileMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      @Nullable OnMessageClickListener listener) {
    return new FileMessageHolder(getItemView(parent, messageType), messageType, listener);
  }

  public FileMessageHolder(View itemView, MessageType messageType, @Nullable OnMessageClickListener listener) {
    super(itemView, messageType);
    this.listener = listener;

    fileLayout = itemView.findViewById(R.id.ch_message_content_file);
    fileIconImage = itemView.findViewById(R.id.icon_file);
    fileNameText = itemView.findViewById(R.id.text_file_name);
    fileInfoText = itemView.findViewById(R.id.text_file_info);
  }

  public void bind(ChatMessageItem item, boolean isConnectedMessage) {
    super.bind(item.getMessage(), item.getType(), isConnectedMessage);

    message = item.getMessage();
    if (message != null) {
      File file = message.getFile();

      if (file != null) {
        setFileMessage(file);
      }
    }
  }

  private void setFileMessage(File file) {
    String fileSize = Utils.getProperBytes(file.getSize());
    String fileType = "";
    String extension = file.getExtension();

    if (!"default".equals(extension) && !TextUtils.isEmpty(extension)) {
      fileType = String.format(" · %s", extension.substring(0, 1).toUpperCase() + extension.substring(1));
    }

    fileLayout.setVisibility(View.VISIBLE);
    fileLayout.setOnClickListener(this);

    fileNameText.setText(file.getFilename());
    fileInfoText.setText(String.format("%s%s", fileSize, fileType));
    fileIconImage.setImageResource(ResUtils.getFileIconResourceId(file));
  }

  @Override
  public void onClick(View v) {
    if (listener != null && message != null) {
      listener.messageClicked(message);
    }
  }
}
