package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

/**
 * Created by jerry on 2018. 3. 28..
 */

public class BaseMessageHolder extends RecyclerView.ViewHolder {

  @Nullable
  protected CHTextView guestMessageTime;
  @Nullable
  protected LinearLayout guestMessageTextLayout;

  @Nullable
  protected LinearLayout managerMessageProfileLayout;
  @Nullable
  protected AvatarLayout managerMessageAvatar;
  @Nullable
  protected CHTextView managerMessageName;
  @Nullable
  protected CHTextView managerMessageTime;
  @Nullable
  protected LinearLayout managerMessageTextLayout;

  protected LinearLayout contentLayout;

  protected Context context;

  public static BaseMessageHolder newInstance(ViewGroup parent, MessageType messageType) {
    return new BaseMessageHolder(getItemView(parent, messageType), messageType);
  }

  public BaseMessageHolder(View itemView, MessageType messageType) {
    super(itemView);
    this.context = itemView.getContext();

    switch (messageType) {
      case GUEST_TEXT_MESSAGE:
      case GUEST_IMAGE_MESSAGE:
      case GUEST_FILE_MESSAGE:
      case GUEST_WEB_MESSAGE:
      case SENDING:
        guestMessageTime = itemView.findViewById(R.id.ch_text_guest_message_time);
        guestMessageTextLayout = itemView.findViewById(R.id.ch_message_content_guest_text);
        break;

      default:
        managerMessageProfileLayout = itemView.findViewById(R.id.ch_layout_manager_message_profile);
        managerMessageAvatar = itemView.findViewById(R.id.ch_avater_manager_message);
        managerMessageTime = itemView.findViewById(R.id.ch_text_manager_message_time);
        managerMessageName = itemView.findViewById(R.id.ch_text_manager_message_name);
        managerMessageTextLayout = itemView.findViewById(R.id.ch_message_content_manager_text);
        break;
    }
    contentLayout = itemView.findViewById(R.id.ch_layout_message_content);
  }

  protected static View getItemView(ViewGroup parent, MessageType messageType) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());

    switch (messageType) {
      case GUEST_TEXT_MESSAGE:
      case GUEST_IMAGE_MESSAGE:
      case GUEST_FILE_MESSAGE:
      case GUEST_WEB_MESSAGE:
      case SENDING:
        return inflater.inflate(R.layout.ch_plugin_item_message_guest, parent, false);

      default:
        return inflater.inflate(R.layout.ch_plugin_item_message_manager2, parent, false);
    }
  }

  public void bind(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
    setLayout(message, messageType, isConnectedMessage);
  }

  private void setLayout(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
    switch (messageType) {
      case GUEST_TEXT_MESSAGE:
      case GUEST_IMAGE_MESSAGE:
      case GUEST_FILE_MESSAGE:
      case GUEST_WEB_MESSAGE:
      case SENDING:
        setGuestMessage(message, isConnectedMessage);
        break;

      default:
        setManagerMessage(message, isConnectedMessage);
        break;
    }
  }

  private void setGuestMessage(@Nullable Message message, boolean isConnectedMessage) {
    if (message != null && guestMessageTime != null) {
      guestMessageTime.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
      guestMessageTime.setText(TimeUtils.getTime(message.getCreatedAt()));

      LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
          ViewGroup.LayoutParams.MATCH_PARENT,
          ViewGroup.LayoutParams.WRAP_CONTENT);
      params.gravity = Gravity.END;
      contentLayout.setGravity(Gravity.END);
      contentLayout.setLayoutParams(params);
    }
  }

  private void setManagerMessage(@Nullable Message message, boolean isConnectedMessage) {
    if (message != null &&
        managerMessageTextLayout != null &&
        managerMessageProfileLayout != null &&
        managerMessageAvatar != null &&
        managerMessageTime != null &&
        managerMessageName != null) {
      ProfileEntity profile = ProfileSelector.getPerson(message.getPersonType(), message.getPersonId());

      managerMessageProfileLayout.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
      managerMessageAvatar.set(profile);

      managerMessageTime.setText(TimeUtils.getTime(message.getCreatedAt()));

      String name;
      if (profile != null) {
        name = profile.getName();
      } else {
        name = ResUtils.getString(context, "ch.unknown");
      }
      managerMessageName.setText(name);

      LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
          ViewGroup.LayoutParams.MATCH_PARENT,
          ViewGroup.LayoutParams.WRAP_CONTENT);
      params.leftMargin = (int) Utils.dpToPx(context, 40);
      params.rightMargin = (int) Utils.dpToPx(context, 74);
      contentLayout.setLayoutParams(params);
    }
  }
}
