package com.zoyi.channel.plugin.android.activity.chat;

import android.animation.Animator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TopNavBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.ConstraintUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.dialog.WorkingTimeDialog;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimatorListener;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

import java.util.List;

public class TopNavFragment extends Fragment implements View.OnClickListener {

  public interface OnChatTopNavListener {

    void onClickTopNav();
  }

  private static final int ANIMATION_DURATION = 400;

  private Context context;

  private ConstraintLayout root;
  private CHTextView textManagerDesc, textResponse, textResDesc;
  private CHTextView textWorkingTimeDetail;
  private AvatarLayout assignManager, firstAvatar, secondAvatar, thirdAvatar;
  private View layoutTopNav, layoutManagerBox, managerAvatarBox, layoutOnline, onlineFrame, layoutAvatarBox, layoutResponseBox, layoutWorkingTime;
  private View reconnectView;

  @Nullable
  private Channel channel;
  @Nullable
  private Person person;
  @Nullable
  private List<Manager> followingManagers;

  private boolean isReady = false, isAnimating = false, avatarAnimated = false;

  @Nullable
  private OnChatTopNavListener listener;

  private Subscription subscription;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_chat_top_nav, container, false);
  }

  @Initializer
  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);
    context = getActivity();
    root = (ConstraintLayout) view.findViewById(R.id.root_chat_top_nav);

    root.setOnClickListener(this);
    layoutTopNav = view.findViewById(R.id.layout_top_nav);

    layoutManagerBox = view.findViewById(R.id.layout_manager_box);
    managerAvatarBox = view.findViewById(R.id.layout_manager_avatar_box);
    assignManager = (AvatarLayout) view.findViewById(R.id.layout_avatar_manager);
    textManagerDesc = view.findViewById(R.id.tv_manager_description);
    layoutOnline = view.findViewById(R.id.layout_online);
    onlineFrame = view.findViewById(R.id.view_online_frame);

    layoutAvatarBox = view.findViewById(R.id.layout_avatar_box);
    firstAvatar = (AvatarLayout) view.findViewById(R.id.layout_avatar_first);
    secondAvatar = (AvatarLayout) view.findViewById(R.id.layout_avatar_second);
    thirdAvatar = (AvatarLayout) view.findViewById(R.id.layout_avatar_third);

    layoutResponseBox = view.findViewById(R.id.layout_response_box);
    textResponse = view.findViewById(R.id.tv_chat_response);
    textResDesc = view.findViewById(R.id.tv_chat_res_description);

    layoutWorkingTime = view.findViewById(R.id.layout_working_time);
    textWorkingTimeDetail = view.findViewById(R.id.tv_working_time_detail);
    layoutWorkingTime.setOnClickListener(this);

    reconnectView = view.findViewById(R.id.layout_reconnect);

    initChannel();
    subscribe();
  }

  @Override
  public void onDestroyView() {
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    super.onDestroyView();
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();

    if (id == R.id.root_chat_top_nav) {
      if (listener != null) {
        listener.onClickTopNav();
      }
    }
    if (id == R.id.layout_working_time) {
      if (channel != null) {
        new WorkingTimeDialog(context, channel.getWorkingTime(context)).show();
      }
    }
  }

  private void initChannel() {
    channel = ChannelSelector.getCurrentChannel();

    layoutTopNav.setBackgroundColor(ColorSelector.getBackgroundColor());
    onlineFrame.getBackground().setColorFilter(ColorSelector.getBackgroundColor(), PorterDuff.Mode.SRC_ATOP);

    assignManager.setBorderColor(ColorSelector.getBackgroundColor());
    firstAvatar.setBorderColor(ColorSelector.getBackgroundColor());
    secondAvatar.setBorderColor(ColorSelector.getBackgroundColor());
    thirdAvatar.setBorderColor(ColorSelector.getBackgroundColor());

    textManagerDesc.setTextColor(ColorSelector.getTextColor());
    textResponse.setTextColor(ColorSelector.getTextColor());
    textResDesc.setTextColor(ColorSelector.getTextColor());
    textWorkingTimeDetail.setTextColor(ColorSelector.getTextColor());
  }

  public void setReconnectVisibility(boolean show) {
    if (reconnectView == null) {
      return;
    }
    if (isReady) {
      ConstraintUtils.connect(
          root,
          R.id.layout_reconnect, ConstraintSet.TOP,
          R.id.layout_top_nav, ConstraintSet.BOTTOM);
    } else {
      ConstraintUtils.connect(
          root,
          R.id.layout_reconnect, ConstraintSet.TOP,
          R.id.root_chat_top_nav, ConstraintSet.TOP);
    }
    reconnectView.setVisibility(UIUtils.getVisible(show, false));
  }

  public boolean isExpand() {
    return layoutTopNav != null && layoutTopNav.getVisibility() == View.VISIBLE;
  }

  public View getRoot() {
    return root;
  }

  public View getLayoutTopNav() {
    return layoutTopNav;
  }

  public int getExpectHeight() {
    int newWidthSpec = View.MeasureSpec.makeMeasureSpec(root.getWidth(), View.MeasureSpec.EXACTLY);
    layoutTopNav.measure(newWidthSpec, View.MeasureSpec.UNSPECIFIED);
    return layoutTopNav.getMeasuredHeight();
  }

  public void setOnChatTopNavListener(OnChatTopNavListener listener) {
    this.listener = listener;
  }

  public void set(@Nullable Person person) {
    initChannel();

    layoutManagerBox.setVisibility(View.VISIBLE);
    layoutResponseBox.setVisibility(View.GONE);
    layoutAvatarBox.setVisibility(View.GONE);
    layoutWorkingTime.setVisibility(View.GONE);

    boolean isSamePerson = isSamePerson(this.person, person);

    this.person = person;
    assignManager.set(person);

    if (person != null && person instanceof Manager) {
      layoutOnline.setVisibility(UIUtils.getVisible(((Manager) person).getOnline(), true));
    } else {
      layoutOnline.setVisibility(View.GONE);
    }

    if (!isSamePerson) {
      managerAvatarBox.animate().scaleX(1.0f).scaleY(1.0f).start();
    } else {
      managerAvatarBox.setScaleX(1.0f);
      managerAvatarBox.setScaleY(1.0f);
    }

    isReady = true;
  }

  private boolean isSamePerson(@Nullable Person p1, @Nullable Person p2) {
    if (p1 == null && p2 == null) {
      return true;
    }
    if (p1 == null || p2 == null) {
      return false;
    }

    return p1.getPersonType().equals(p2.getPersonType()) && p1.getId().equals(p2.getId());
  }

  public void set(List<Manager> followingManagers) {
    initChannel();

    if (channel == null) {
      return;
    }

    layoutManagerBox.setVisibility(View.INVISIBLE);

    setAvatar(followingManagers);
    setResponse();
    setWorkingTime();

    isReady = true;
  }

  public void setChannel(Channel channel) {
    this.channel = channel;
    setResponse();
    setWorkingTime();
    setAvatar();
  }

  private void setAvatar() {
    setAvatar(followingManagers);
  }

  public void setAvatar(@Nullable List<Manager> followingManagers) {
    if (followingManagers == null || followingManagers.isEmpty()) {
      layoutAvatarBox.setVisibility(View.GONE);
      return;
    }

    this.followingManagers = followingManagers;
    layoutAvatarBox.setVisibility(View.VISIBLE);

    int size = ChatResponseManager.showOnlyOneManager(channel) ? 1 : followingManagers.size();

    if (size == 1) {
      showOnlyFirstAvatar(followingManagers);
    } else if (size == 2) {
      firstAvatar.set(followingManagers.get(0));
      firstAvatar.setVisibility(View.VISIBLE);
      secondAvatar.set(followingManagers.get(1));
      secondAvatar.setVisibility(View.VISIBLE);
      thirdAvatar.setVisibility(View.GONE);
    } else {
      firstAvatar.set(followingManagers.get(0));
      firstAvatar.setVisibility(View.VISIBLE);
      secondAvatar.set(followingManagers.get(1));
      secondAvatar.setVisibility(View.VISIBLE);
      thirdAvatar.set(followingManagers.get(2));
      thirdAvatar.setVisibility(View.VISIBLE);
    }
  }

  private void showOnlyFirstAvatar(List<Manager> followingManagers) {
    firstAvatar.set(followingManagers.get(0));
    firstAvatar.setVisibility(View.VISIBLE);
    secondAvatar.setVisibility(View.GONE);
    thirdAvatar.setVisibility(View.GONE);
  }

  private void setResponse() {
    layoutResponseBox.setVisibility(View.VISIBLE);

    textResponse.setCompoundDrawablesWithIntrinsicBounds(
        0,
        0,
        ChatResponseManager.getResponseSymbol(channel),
        0);
    textResponse.setTextByKey(ChatResponseManager.getResponseKey(channel));

    String responseDescription = ChatResponseManager.getResponseDescriptionKey(channel);
    textResDesc.setTextByKey(responseDescription);
  }

  private void setWorkingTime() {
    if (channel == null ||
        (channel.isWorking() ||
            Const.WORKING_TYPE_NEVER.equals(channel.getWorkingType()) ||
            channel.getWorkingTime(context) == null)) {
      layoutWorkingTime.setVisibility(View.GONE);
    } else {
      layoutWorkingTime.setVisibility(View.VISIBLE);
    }
  }

  private void subscribe() {
    subscription = RxBus.observable().subscribe(new Action1<Object>() {
      @Override
      public void call(Object o) {
        if (o != null) {
          if (o instanceof TopNavBus.TranslationY) {
            setTranslationY(((TopNavBus.TranslationY) o).value);
          } else if (o instanceof TopNavBus.Expand) {
            expand();
          } else if (o instanceof TopNavBus.Collapse) {
            collapse();
          }
        }
      }
    });
  }

  public void setTranslationY(float value) {
    if (root == null) {
      return;
    }
    layoutTopNav.setVisibility(
        layoutTopNav.getHeight() == Math.abs(value)
            ? View.INVISIBLE : View.VISIBLE);
    root.setTranslationY(value);
    animateAvatar();
  }

  public void expand() {
    if (!isReady) {
      return;
    }
    layoutTopNav.setVisibility(View.VISIBLE);

    if (root == null || root.getHeight() <= 0 || isAnimating) {
      return;
    }

    root.animate()
        .translationY(0)
        .setDuration(ANIMATION_DURATION)
        .setListener(new SimpleAnimatorListener() {
          @Override
          public void onAnimationStart(Animator animation) {
            isAnimating = true;
            animateAvatar();
          }

          @Override
          public void onAnimationEnd(Animator animation) {
            isAnimating = false;
          }
        })
        .start();
  }

  private void animateAvatar() {
    if (!avatarAnimated) {
      avatarAnimated = true;

      processAvatarScale(firstAvatar, 200);
      processAvatarScale(secondAvatar, 250);
      processAvatarScale(thirdAvatar, 300);
    }
  }

  private void processAvatarScale(final AvatarLayout avatarLayout, long delayMillis) {
    new Handler().postDelayed(new Runnable() {
      @Override
      public void run() {
        avatarLayout.animate().scaleX(1.0f).scaleY(1.0f).start();
      }
    }, delayMillis);
  }

  public void collapse() {
    if (!isReady || root == null || root.getHeight() <= 0 || isAnimating) {
      return;
    }

    root.animate()
        .translationY(-layoutTopNav.getHeight())
        .setDuration(ANIMATION_DURATION)
        .setListener(new SimpleAnimatorListener() {
          @Override
          public void onAnimationStart(Animator animation) {
            isAnimating = true;
          }

          @Override
          public void onAnimationEnd(Animator animation) {
            isAnimating = false;

            layoutTopNav.setVisibility(View.INVISIBLE);
          }
        })
        .start();
  }
}
