/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.BaseMessageHolder;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Resizer;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.BitmapRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;

public class SendingMessageHolder
extends BaseMessageHolder
implements View.OnClickListener {
    protected View root;
    protected View resendLocalContentButton;
    protected View localTextLayout;
    protected View localTextHeadLayout;
    protected View localTextHeadBackground;
    protected View localTextContentLayout;
    protected View localTextContentBackground;
    protected CHTextView localMessageText;
    protected View localImageLayout;
    protected MaskableFrameLayout localImageLoadingLayout;
    protected ImageView imagePlaceholder;
    protected ImageView imageLoading;
    protected View localImageProgressView;
    protected View localImageUploadFailedView;
    private Context context;
    @Nullable
    private OnSendingMessageClickListener listener;
    @Nullable
    private SendingMessageItem item;

    public static SendingMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnSendingMessageClickListener listener) {
        return new SendingMessageHolder(SendingMessageHolder.getItemView(parent, messageType), messageType, listener);
    }

    public SendingMessageHolder(View itemView, MessageType messageType, @Nullable OnSendingMessageClickListener listener) {
        super(itemView, messageType);
        this.context = itemView.getContext();
        this.listener = listener;
        this.root = itemView.findViewById(R.id.ch_message_content_loading);
        this.localMessageText = (CHTextView)itemView.findViewById(R.id.ch_text_local_message);
        this.localTextLayout = itemView.findViewById(R.id.ch_layout_local_message_text);
        this.localTextHeadLayout = itemView.findViewById(R.id.ch_layout_local_message_head);
        this.localTextHeadBackground = itemView.findViewById(R.id.ch_view_local_message_head_top);
        this.localTextContentLayout = itemView.findViewById(R.id.ch_layout_local_message_content);
        this.localTextContentBackground = itemView.findViewById(R.id.ch_view_local_message_content_top);
        this.imagePlaceholder = (ImageView)itemView.findViewById(R.id.image_placeholder);
        this.imageLoading = (ImageView)itemView.findViewById(R.id.image_loading);
        this.localImageLayout = itemView.findViewById(R.id.ch_layout_local_message_image_content);
        this.localImageLoadingLayout = (MaskableFrameLayout)itemView.findViewById(R.id.ch_layout_local_message_image);
        this.localImageProgressView = itemView.findViewById(R.id.progress_upload);
        this.localImageUploadFailedView = itemView.findViewById(R.id.image_upload_failed);
        this.resendLocalContentButton = itemView.findViewById(R.id.ch_button_local_message_resend);
        this.resendLocalContentButton.setOnClickListener((View.OnClickListener)this);
    }

    public void bind(SendingMessageItem item, boolean isConnected) {
        super.bind(null, item.getType(), true);
        this.item = item;
        this.root.setVisibility(0);
        this.localImageLayout.setVisibility(8);
        this.localTextLayout.setVisibility(8);
        this.resendLocalContentButton.setVisibility(UIUtils.getVisible(!item.isSending(), true));
        if (this.guestMessageTextLayout != null) {
            this.guestMessageTextLayout.setVisibility(8);
        }
        if (this.guestMessageTime != null) {
            this.guestMessageTime.setVisibility(8);
        }
        this.localTextHeadLayout.setVisibility(UIUtils.getVisible(!isConnected, true));
        this.localTextContentLayout.setVisibility(UIUtils.getVisible(isConnected, true));
        if (item.isImage()) {
            this.setLocalImageMessage(item);
        } else {
            this.setLocalTextMessage(item);
        }
    }

    private void setLocalImageMessage(SendingMessageItem item) {
        if (item.getString() != null) {
            String imagePath = item.getString();
            Point previewImageSize = Utils.resizeImage(this.context, Utils.getImageArea(imagePath));
            Resizer.size(this.localImageLayout, previewImageSize.x, previewImageSize.y);
            ((BitmapRequestBuilder)((BitmapRequestBuilder)((BitmapRequestBuilder)Glide.with(this.itemView.getContext()).load(imagePath).asBitmap().override(previewImageSize.x, previewImageSize.y)).dontAnimate()).centerCrop()).into(this.imageLoading);
            this.imagePlaceholder.setVisibility(8);
            this.localImageLayout.setVisibility(0);
            this.localImageLoadingLayout.setVisibility(0);
            this.localImageProgressView.setVisibility(UIUtils.getVisible(item.isSending(), true));
            this.localImageUploadFailedView.setVisibility(UIUtils.getVisible(!item.isSending(), true));
        }
    }

    private void setLocalTextMessage(SendingMessageItem item) {
        String localMessage = MessageParser.get() != null ? MessageParser.get().parse(item.getMessage()) : item.getMessage();
        this.localTextLayout.setVisibility(0);
        this.localMessageText.setText(localMessage);
        this.localMessageText.setTextColor(ColorSelector.getTextColor());
        this.localMessageText.setBackgroundColor(ColorSelector.getBackgroundColor());
        this.localTextHeadBackground.setBackgroundColor(ColorSelector.getBackgroundColor());
        this.localTextContentBackground.setBackgroundColor(ColorSelector.getBackgroundColor());
    }

    public void onClick(View v) {
        if (this.listener != null && this.item != null) {
            this.listener.requestResendClicked(this.item);
        }
    }
}

