package com.zoyi.channel.plugin.android.activity.settings;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.SwitchCompat;
import android.view.View;
import android.widget.CompoundButton;
import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.settings.setting_language.SettingLanguageActivity;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.UserChatStore;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

import static android.widget.CompoundButton.OnCheckedChangeListener;

public class SettingsActivity extends BaseActivity implements OnCheckedChangeListener, View.OnClickListener {

  private CHTextView languageSettingText;

  private boolean completed = false;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_setting);

    setBigBar();
    initView();
  }

  private void setBigBar() {
    if (getBigBar() != null) {
      getBigBar().withActivity(this)
          .addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT)
          .build();
      getBigBar().setTitleByKey("ch.settings.title");
    }
  }

  private void initView() {
    languageSettingText = findViewById(R.id.ch_text_setting_language);

    findViewById(R.id.iv_channel_symbol).setOnClickListener(this);
    findViewById(R.id.ch_button_setting_language).setOnClickListener(this);

    CHTextView textVersion = findViewById(R.id.tv_plugin_version);
    textVersion.setText(BuildConfig.VERSION_NAME);

    completed = PrefSupervisor.isShownClosedChat(this);

    SwitchCompat switchCompleted = (SwitchCompat) findViewById(R.id.sw_show_closed_chat);
    switchCompleted.setChecked(completed);
    switchCompleted.setOnCheckedChangeListener(this);

    SwitchCompat switchAlarm = (SwitchCompat) findViewById(R.id.sw_enable_alarm);
    switchAlarm.setChecked(PrefSupervisor.isEnabledPushAlarm(this));
    switchAlarm.setOnCheckedChangeListener(this);

    setLanguageSettingText();
  }

  private void setLanguageSettingText() {
    String languageCode = PrefSupervisor.getPluginLanguage(this);

    languageSettingText.setTextByKey(languageCode);
  }


  @Override
  public void onClick(View v) {
    int id = v.getId();
    if (id == R.id.iv_channel_symbol && getUrl() != null) {
      Executor.goWeb(this, getUrl());
    }

    if (id == R.id.ch_button_setting_language) {
      IntentUtils
          .setNextActivity(this, SettingLanguageActivity.class)
          .startActivityForResult(Const.REQUEST_LANGUAGE);
    }
  }

  @Nullable
  private String getUrl() {
    Channel channel = ChannelSelector.getCurrentChannel();

    if (channel != null && channel.getName() != null && channel.getId() != null) {
      return String.format(
          Const.UTM_URL,
          PrefSupervisor.getPluginLanguage(this),
          "plugin_exposure",
          channel.getName(),
          channel.getId());
    }
    return null;
  }

  @Override
  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
    int id = buttonView.getId();

    if (id == R.id.sw_show_closed_chat) {
      handleShowClosedChat(isChecked);
    }
    if (id == R.id.sw_enable_alarm) {
      PrefSupervisor.setPushAlarm(this, isChecked);
    }
  }

  private void handleShowClosedChat(boolean isChecked) {
    if (completed == isChecked) {
      setResult(Activity.RESULT_CANCELED);
    } else {
      setResult(Const.RESULT_CHAT_OPTION_CHANGED);
    }
    PrefSupervisor.setShowClosedChat(this, isChecked);
    Store.getInstance(UserChatStore.class).setShowClosed(isChecked);
  }


  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    if (requestCode == Const.REQUEST_LANGUAGE && resultCode == Const.RESULT_CHANGE_LOCALE) {
      languageSettingText.setTextByKey(PrefSupervisor.getPluginLanguage(this));
    }
  }

  @Override
  @AnimRes
  protected int getExistAnimOfFinish() {
    return R.anim.ch_plugin_slide_out_bottom;
  }
}
