package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

/**
 * Created by jerry on 2018. 3. 30..
 */

public class TextMessageHolder extends BaseMessageHolder {

  @Nullable
  protected MaskableFrameLayout guestMessageHeadLayout;
  @Nullable
  protected MaskableFrameLayout guestMessageContentLayout;
  @Nullable
  protected CHTextView guestMessageText;
  @Nullable
  protected View guestMessageTopView;
  @Nullable
  protected View guestMessageContentView;

  @Nullable
  protected View managerMessageHeadTop;
  @Nullable
  protected View managerMessageContextTop;
  @Nullable
  protected CHTextView managerMessageText;

  public static TextMessageHolder newInstance(ViewGroup parent, MessageType messageType) {
    return new TextMessageHolder(getItemView(parent, messageType), messageType);
  }

  public TextMessageHolder(View itemView, MessageType messageType) {
    super(itemView, messageType);

    switch (messageType) {
      case GUEST_TEXT_MESSAGE:
      case GUEST_IMAGE_MESSAGE:
      case GUEST_FILE_MESSAGE:
      case GUEST_WEB_MESSAGE:
        guestMessageHeadLayout = itemView.findViewById(R.id.ch_layout_guest_message_head);
        guestMessageContentLayout = itemView.findViewById(R.id.ch_layout_guest_message_content);
        guestMessageText = itemView.findViewById(R.id.ch_text_guest_message);
        guestMessageTopView = itemView.findViewById(R.id.ch_view_guest_message_head_top);
        guestMessageContentView = itemView.findViewById(R.id.ch_view_guest_message_content_top);
        break;

      default:
        managerMessageHeadTop = itemView.findViewById(R.id.ch_view_manager_message_head_top);
        managerMessageContextTop = itemView.findViewById(R.id.ch_view_manager_message_context_top);
        managerMessageText = itemView.findViewById(R.id.ch_text_manager_message);
        break;
    }
  }

  public void bind(ChatMessageItem item, boolean isConnectedMessage) {
    super.bind(item.getMessage(), item.getType(), isConnectedMessage);

    switch (item.getType()) {
      case GUEST_TEXT_MESSAGE:
      case GUEST_IMAGE_MESSAGE:
      case GUEST_FILE_MESSAGE:
      case GUEST_WEB_MESSAGE:
        setGuestMessageText(item, isConnectedMessage);
        break;

      default:
        setManagerMessageText(item, isConnectedMessage);
        break;
    }
  }

  private void setGuestMessageText(ChatMessageItem item, boolean isConnectedMessage) {
    if (item.getMessage().getMessage() != null &&
        guestMessageTextLayout != null &&
        guestMessageHeadLayout != null &&
        guestMessageContentLayout != null &&
        guestMessageText != null &&
        guestMessageTopView != null &&
        guestMessageContentView != null) {
      guestMessageTextLayout.setVisibility(View.VISIBLE);
      guestMessageHeadLayout.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
      guestMessageContentLayout.setVisibility(UIUtils.getVisible(isConnectedMessage, true));

      guestMessageTopView.setBackgroundColor(ColorSelector.getBackgroundColor());
      guestMessageContentView.setBackgroundColor(ColorSelector.getBackgroundColor());

      guestMessageText.setBackgroundColor(ColorSelector.getBackgroundColor());
      guestMessageText.setTextColor(ColorSelector.getTextColor());
      guestMessageText.setLinkTextColor(ColorSelector.getTextColor());
      guestMessageText.setMovementMethod(LinkMovementMethod.getInstance());
      guestMessageText.setText(item.getMessage().getFormattedSpanMessage());
    }
  }

  private void setManagerMessageText(ChatMessageItem item, boolean isConnectedMessage) {
    if (item.getMessage().getMessage() != null &&
        managerMessageTextLayout != null &&
        managerMessageHeadTop != null &&
        managerMessageContextTop != null &&
        managerMessageText != null) {
      managerMessageTextLayout.setVisibility(View.VISIBLE);
      managerMessageHeadTop.setVisibility(UIUtils.getVisible(!isConnectedMessage, true));
      managerMessageContextTop.setVisibility(UIUtils.getVisible(isConnectedMessage, true));

      managerMessageText.setText(item.getMessage().getFormattedSpanMessage());
      managerMessageText.setMovementMethod(LinkMovementMethod.getInstance());
    }
  }
}
